/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.dispatcher;

import com.arsdigita.bebop.parameters.BigDecimalParameter;
import com.arsdigita.cms.Asset;
import com.arsdigita.cms.BinaryAsset;
import com.arsdigita.cms.dispatcher.ResourceHandlerImpl;
import com.arsdigita.dispatcher.DispatcherHelper;
import com.arsdigita.dispatcher.RequestContext;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.mimetypes.MimeType;
import com.arsdigita.persistence.OID;
import com.arsdigita.toolbox.ui.OIDParameter;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

class BaseAsset
extends ResourceHandlerImpl {
    public static final String versionId = "$Id: //cms/dev/src/com/arsdigita/cms/dispatcher/BaseAsset.java#8 $ by $Author: dan $, $DateTime: 2004/05/10 10:32:44 $";
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$cms$dispatcher$BaseAsset == null ? (class$com$arsdigita$cms$dispatcher$BaseAsset = BaseAsset.class$("com.arsdigita.cms.dispatcher.BaseAsset")) : class$com$arsdigita$cms$dispatcher$BaseAsset));
    public static final String ASSET_ID = "asset_id";
    public static final String OID_PARAM = "oid";
    private static final String s_defaultName = "File";
    private static final BigDecimalParameter s_assetId = new BigDecimalParameter("asset_id");
    private static final OIDParameter s_oid = new OIDParameter("oid");
    private final boolean m_download;
    static /* synthetic */ Class class$com$arsdigita$cms$dispatcher$BaseAsset;

    protected BaseAsset(boolean download) {
        this.m_download = download;
    }

    private void setFilenameHeader(HttpServletResponse response, BinaryAsset asset) {
        String filename = asset.getName();
        if (filename == null) {
            filename = s_defaultName;
        }
        StringBuffer quotedString = new StringBuffer("\"");
        quotedString.append(filename).append("\"");
        response.setHeader("Content-Disposition", "attachment; filename=" + quotedString.toString());
    }

    private void setHeaders(HttpServletResponse response, BinaryAsset asset) {
        this.setFilenameHeader(response, asset);
        Long contentLength = new Long(asset.getSize());
        response.setContentLength(contentLength.intValue());
        MimeType mimeType = asset.getMimeType();
        if (this.m_download || mimeType == null) {
            response.setContentType("application/octet-stream");
        } else {
            response.setContentType(mimeType.getMimeType());
        }
        DispatcherHelper.cacheForWorld((HttpServletResponse)response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void send(HttpServletResponse response, BinaryAsset asset) throws IOException {
        ServletOutputStream out = response.getOutputStream();
        try {
            asset.writeBytes((OutputStream)out);
        }
        finally {
            out.close();
        }
    }

    public final void dispatch(HttpServletRequest request, HttpServletResponse response, RequestContext actx) throws IOException, ServletException {
        BinaryAsset asset;
        BigDecimal assetId;
        block9: {
            OID oid = (OID)s_oid.transformValue(request);
            assetId = (BigDecimal)s_assetId.transformValue(request);
            if (assetId == null && oid == null) {
                throw new ServletException("asset_id or oid is required.");
            }
            if (assetId != null && oid != null) {
                throw new ServletException("asset_id or oid must not both be specified.");
            }
            if (oid == null) {
                oid = new OID("com.arsdigita.cms.Asset", (Object)assetId);
            }
            asset = null;
            try {
                Asset a = (Asset)DomainObjectFactory.newInstance((OID)oid);
                if (a instanceof BinaryAsset) {
                    asset = (BinaryAsset)a;
                } else if (s_log.isInfoEnabled()) {
                    s_log.info((Object)("Asset " + oid + " is not a BinaryAsset"));
                }
            }
            catch (DataObjectNotFoundException nfe) {
                if (!s_log.isInfoEnabled()) break block9;
                s_log.info((Object)("no asset with oid " + oid), (Throwable)nfe);
            }
        }
        if (asset == null) {
            response.sendError(404, "No asset with ID " + assetId);
            return;
        }
        this.setHeaders(response, asset);
        this.send(response, asset);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

