/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.contenttypes.ui;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.ControlLink;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.Table;
import com.arsdigita.bebop.event.TableActionEvent;
import com.arsdigita.bebop.event.TableActionListener;
import com.arsdigita.bebop.table.TableCellRenderer;
import com.arsdigita.bebop.table.TableColumn;
import com.arsdigita.bebop.table.TableColumnModel;
import com.arsdigita.cms.ItemSelectionModel;
import com.arsdigita.cms.contenttypes.Link;
import com.arsdigita.cms.contenttypes.ui.LinkSelectionModel;
import com.arsdigita.cms.contenttypes.ui.LinkTable;
import com.arsdigita.dispatcher.DispatcherHelper;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.util.Assert;
import com.arsdigita.util.UncheckedWrapperException;
import java.io.IOException;
import java.math.BigDecimal;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class LinkDisplayTable
extends LinkTable {
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$cms$contenttypes$ui$LinkDisplayTable == null ? (class$com$arsdigita$cms$contenttypes$ui$LinkDisplayTable = LinkDisplayTable.class$("com.arsdigita.cms.contenttypes.ui.LinkDisplayTable")) : class$com$arsdigita$cms$contenttypes$ui$LinkDisplayTable));
    ItemSelectionModel m_itemModel;
    LinkSelectionModel m_linkModel;
    private TableColumn m_titleCol;
    private TableColumn m_descCol;
    static /* synthetic */ Class class$com$arsdigita$cms$contenttypes$ui$LinkDisplayTable;

    public LinkDisplayTable(ItemSelectionModel item, LinkSelectionModel link) {
        super(item, link);
        this.m_itemModel = item;
        this.m_linkModel = link;
        this.setDefaultCellRenderer(new LinkDisplayTableCellRenderer());
        this.addTableActionListener(new LinkDisplayTableActionListener());
    }

    protected void addColumnModel() {
        s_log.debug((Object)"Setting columns to be display");
        TableColumnModel model = this.getColumnModel();
        this.m_titleCol = new TableColumn(0, (Object)"Title");
        this.m_descCol = new TableColumn(2, (Object)"Description");
        model.add(this.m_titleCol);
        model.add(this.m_descCol);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class LinkDisplayTableActionListener
    implements TableActionListener {
        private LinkDisplayTableActionListener() {
        }

        private Link getLink(TableActionEvent e) {
            Link link;
            String id = (String)e.getRowKey();
            Assert.assertNotNull((Object)id);
            try {
                link = new Link(new BigDecimal(id));
            }
            catch (DataObjectNotFoundException ex) {
                throw new RuntimeException(ex.getMessage());
            }
            return link;
        }

        public void cellSelected(TableActionEvent e) {
            int col = e.getColumn();
            PageState state = e.getPageState();
            Link link = this.getLink(e);
            if (col == LinkDisplayTable.this.m_titleCol.getModelIndex()) {
                String url = link.getInternalOrExternalURI(state);
                s_log.debug((Object)("Redirecting to : " + url));
                try {
                    DispatcherHelper.sendRedirect((HttpServletRequest)state.getRequest(), (HttpServletResponse)state.getResponse(), (String)url);
                }
                catch (IOException ex) {
                    throw new UncheckedWrapperException("Failed to redirect", (Throwable)ex);
                }
            }
        }

        public void headSelected(TableActionEvent e) {
        }
    }

    private class LinkDisplayTableCellRenderer
    implements TableCellRenderer {
        private LinkDisplayTableCellRenderer() {
        }

        public Component getComponent(Table table, PageState state, Object value, boolean isSelected, Object key, int row, int column) {
            Link link = (Link)((Object)value);
            if (column == LinkDisplayTable.this.m_titleCol.getModelIndex()) {
                return new ControlLink(link.getTitle());
            }
            if (column == LinkDisplayTable.this.m_descCol.getModelIndex()) {
                return new Label(link.getDescription());
            }
            throw new UncheckedWrapperException("column out of bounds");
        }
    }
}

