/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms;

import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.ObjectCopier;
import com.arsdigita.cms.PublishedLink;
import com.arsdigita.cms.lifecycle.Lifecycle;
import com.arsdigita.cms.lifecycle.LifecycleService;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.metadata.Property;
import com.arsdigita.util.Assert;
import java.util.HashSet;
import org.apache.log4j.Logger;

class VersionCopier
extends ObjectCopier {
    public static final String versionId = "$Id: //cms/dev/src/com/arsdigita/cms/VersionCopier.java#12 $$Author: dennis $$DateTime: 2004/04/07 16:07:11 $";
    private static Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$cms$VersionCopier == null ? (class$com$arsdigita$cms$VersionCopier = VersionCopier.class$("com.arsdigita.cms.VersionCopier")) : class$com$arsdigita$cms$VersionCopier));
    private final Lifecycle m_lifecycle;
    private boolean m_once = false;
    private long m_start = 0L;
    private final HashSet m_traversedComponents = new HashSet();
    private OID m_topLevelSourceOID = null;
    static /* synthetic */ Class class$com$arsdigita$cms$VersionCopier;
    static /* synthetic */ Class class$com$arsdigita$domain$DomainObject;
    static /* synthetic */ Class class$com$arsdigita$persistence$metadata$Property;

    VersionCopier(Lifecycle lifecycle) {
        this.m_lifecycle = lifecycle;
    }

    VersionCopier() {
        this.m_lifecycle = null;
    }

    public ContentItem copyItem(ContentItem item) {
        this.m_trace.enter("copyItem", (Object)item);
        if (s_log.isInfoEnabled()) {
            s_log.info((Object)("Publishing " + item));
            this.m_start = System.currentTimeMillis();
        }
        if (Assert.isEnabled()) {
            Assert.falsity((boolean)this.m_once);
            this.m_once = true;
        }
        this.m_topLevelSourceOID = item.getOID();
        ContentItem version = this.createVersion(item);
        if (this.m_lifecycle != null) {
            LifecycleService.setLifecycle((ACSObject)version, this.m_lifecycle);
        }
        this.m_trace.exit("copyItem", (Object)version);
        if (Assert.isEnabled()) {
            this.m_once = false;
        }
        if (s_log.isInfoEnabled()) {
            s_log.info((Object)("Done publishing " + item + " (" + (System.currentTimeMillis() - this.m_start) + " millis)"));
        }
        return version;
    }

    public int getCopyType() {
        return 1;
    }

    public DomainObject copy(DomainObject object) {
        if (object != null) {
            this.m_traversedComponents.add(object);
        }
        return super.copy(object);
    }

    protected DomainObject copy(DomainObject source, DomainObject target, DomainObject object, Property prop) {
        this.m_trace.enter("copy", (Object)object, (Object)prop);
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Copying property " + prop + " of " + object));
        }
        Assert.exists((Object)source, (Class)(class$com$arsdigita$domain$DomainObject == null ? (class$com$arsdigita$domain$DomainObject = VersionCopier.class$("com.arsdigita.domain.DomainObject")) : class$com$arsdigita$domain$DomainObject));
        Assert.exists((Object)target, (Class)(class$com$arsdigita$domain$DomainObject == null ? (class$com$arsdigita$domain$DomainObject = VersionCopier.class$("com.arsdigita.domain.DomainObject")) : class$com$arsdigita$domain$DomainObject));
        Assert.exists((Object)object, (Class)(class$com$arsdigita$domain$DomainObject == null ? (class$com$arsdigita$domain$DomainObject = VersionCopier.class$("com.arsdigita.domain.DomainObject")) : class$com$arsdigita$domain$DomainObject));
        Assert.exists((Object)prop, (Class)(class$com$arsdigita$persistence$metadata$Property == null ? (class$com$arsdigita$persistence$metadata$Property = VersionCopier.class$("com.arsdigita.persistence.metadata.Property")) : class$com$arsdigita$persistence$metadata$Property));
        if (object instanceof ContentItem) {
            s_log.debug((Object)"The property is a content item");
            ContentItem item = (ContentItem)object;
            if (Assert.isEnabled()) {
                item.assertDraft();
            }
            if (prop.isComponent()) {
                s_log.debug((Object)"The property is a component; creating a live or pending version");
                ContentItem copy = this.createVersion(item);
                this.m_trace.exit("copy", (Object)copy);
                return copy;
            }
            if (this.m_traversedComponents.contains(object)) {
                DomainObject copy = this.copy(object);
                this.m_trace.exit("copy", (Object)copy);
                return copy;
            }
            if (prop.isRequired()) {
                Assert.fail((String)"1..1 associations to non-component top-level ContentItems are not allowed");
                return null;
            }
            s_log.debug((Object)"The property is not a component; creating PublishedLink for the item");
            PublishedLink.create((ContentItem)this.getCopy(this.m_topLevelSourceOID), target, prop.getName(), item);
            this.m_trace.exit("copy", null);
            return null;
        }
        s_log.debug((Object)"The property is not a content item; using domain object copier");
        DomainObject copy = super.copy(source, target, object, prop);
        this.m_trace.exit("copy", (Object)copy);
        return copy;
    }

    private ContentItem createVersion(ContentItem item) {
        this.m_trace.enter("createVersion", (Object)item);
        if (Assert.isEnabled()) {
            item.assertDraft();
        }
        ContentItem version = (ContentItem)this.copy((DomainObject)item);
        s_log.debug((Object)"The copy is pending; associating it with the draft item");
        version.setVersion("pending");
        item.addPendingVersion(version);
        version.copyServicesFrom(item);
        this.m_trace.exit("createVersion", (Object)version);
        return version;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

