/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.ui.templates;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.ParameterSingleSelectionModel;
import com.arsdigita.bebop.RequestLocal;
import com.arsdigita.bebop.SingleSelectionModel;
import com.arsdigita.bebop.Table;
import com.arsdigita.bebop.parameters.BigDecimalParameter;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.bebop.table.TableCellRenderer;
import com.arsdigita.bebop.table.TableColumn;
import com.arsdigita.categorization.Category;
import com.arsdigita.cms.CategoryTemplateMapping;
import com.arsdigita.cms.ContentType;
import com.arsdigita.cms.TemplateCollection;
import com.arsdigita.cms.TemplateMapping;
import com.arsdigita.cms.ui.category.CategoryRequestLocal;
import com.arsdigita.cms.ui.templates.TemplatesListing;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.kernel.ui.ACSObjectSelectionModel;
import com.arsdigita.persistence.DataObject;

public abstract class CategoryTemplatesListing
extends TemplatesListing {
    private CategoryRequestLocal m_category;
    private TableColumn m_typeCol;
    private RequestLocal m_currentContext;

    public CategoryTemplatesListing(CategoryRequestLocal category) {
        super(new MappingSelectionModel());
        this.m_category = category;
        this.setDataQueryBuilder(new TemplatesListing.AbstractQueryBuilder());
        this.m_typeCol = this.addColumn("Content Type", "contentType", false, new TypeCellRenderer());
        this.addRemoveColumn();
    }

    public final TableColumn getTypeColumn() {
        return this.m_typeCol;
    }

    protected TemplateCollection getTemplateCollection(PageState s) {
        Category category = this.m_category.getCategory(s);
        return CategoryTemplateMapping.getTemplates(category);
    }

    protected void removeTemplate(PageState s, TemplateMapping m) {
        if (m == null) {
            return;
        }
        m.delete();
    }

    protected static class TypeCellRenderer
    implements TableCellRenderer {
        public Component getComponent(Table table, PageState state, Object value, boolean isSelected, Object key, int row, int column) {
            ContentType type = (ContentType)DomainObjectFactory.newInstance((DataObject)((DataObject)value));
            return new Label(type.getLabel());
        }
    }

    private static class MappingSelectionModel
    extends ACSObjectSelectionModel {
        public static final String MAPPING = "m";

        public MappingSelectionModel() {
            super((SingleSelectionModel)new ParameterSingleSelectionModel((ParameterModel)new BigDecimalParameter(MAPPING)));
        }
    }
}

