/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.ui.lifecycle;

import com.arsdigita.bebop.ActionLink;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Container;
import com.arsdigita.bebop.FormSection;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.Page;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.bebop.Table;
import com.arsdigita.bebop.event.ActionEvent;
import com.arsdigita.bebop.event.ActionListener;
import com.arsdigita.bebop.table.DefaultTableCellRenderer;
import com.arsdigita.bebop.table.TableCellRenderer;
import com.arsdigita.bebop.table.TableModelBuilder;
import com.arsdigita.cms.CMS;
import com.arsdigita.cms.lifecycle.LifecycleDefinition;
import com.arsdigita.cms.lifecycle.PhaseDefinition;
import com.arsdigita.cms.ui.BaseItemPane;
import com.arsdigita.cms.ui.lifecycle.AddPhaseForm;
import com.arsdigita.cms.ui.lifecycle.DeletePhaseForm;
import com.arsdigita.cms.ui.lifecycle.EditPhaseForm;
import com.arsdigita.cms.ui.lifecycle.LifecycleAdminContainer;
import com.arsdigita.cms.ui.lifecycle.LifecycleDefinitionRequestLocal;
import com.arsdigita.cms.ui.lifecycle.PhaseRequestLocal;
import com.arsdigita.cms.ui.lifecycle.PhaseTableModelBuilder;
import com.arsdigita.toolbox.ui.ActionGroup;
import com.arsdigita.toolbox.ui.PropertyList;
import com.arsdigita.toolbox.ui.Section;
import java.math.BigDecimal;
import java.util.List;
import org.apache.log4j.Logger;

class LifecycleItemPane
extends BaseItemPane {
    public static final String versionId = "$Id: //cms/dev/src/com/arsdigita/cms/ui/lifecycle/LifecycleItemPane.java#13 $$Author: dennis $$DateTime: 2004/04/07 16:07:11 $";
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$cms$ui$lifecycle$LifecycleItemPane == null ? (class$com$arsdigita$cms$ui$lifecycle$LifecycleItemPane = LifecycleItemPane.class$("com.arsdigita.cms.ui.lifecycle.LifecycleItemPane")) : class$com$arsdigita$cms$ui$lifecycle$LifecycleItemPane));
    private final LifecycleDefinitionRequestLocal m_cycle;
    private final PhaseRequestLocal m_phase;
    private final Container m_detailPane;
    private final Table m_phases;
    private static final String[] s_headers = new String[]{LifecycleItemPane.lz("cms.ui.name"), LifecycleItemPane.lz("cms.ui.description"), LifecycleItemPane.lz("cms.ui.lifecycle.phase.delay"), LifecycleItemPane.lz("cms.ui.lifecycle.phase.duration"), "", ""};
    static /* synthetic */ Class class$com$arsdigita$cms$ui$lifecycle$LifecycleItemPane;

    public LifecycleItemPane(LifecycleDefinitionRequestLocal cycle, ActionLink editLink, ActionLink deleteLink) {
        this.m_cycle = cycle;
        this.m_phase = new SelectionRequestLocal();
        this.m_phases = new PhaseTable();
        this.m_detailPane = new SimpleContainer();
        this.add((Component)this.m_detailPane);
        this.setDefault((Component)this.m_detailPane);
        this.m_detailPane.add((Component)new SummarySection(editLink, deleteLink));
        ActionLink phaseAddLink = new ActionLink((Component)new Label(LifecycleItemPane.gz("cms.ui.lifecycle.phase.add")));
        this.m_detailPane.add((Component)new PhaseSection(phaseAddLink));
        AddPhaseForm phaseAddForm = new AddPhaseForm(this.m_cycle);
        EditPhaseForm phaseEditForm = new EditPhaseForm(this.m_phase);
        DeletePhaseForm phaseDeleteForm = new DeletePhaseForm(this.m_phase);
        this.add((Component)phaseAddForm);
        this.add((Component)phaseEditForm);
        this.add((Component)phaseDeleteForm);
        this.connect(phaseAddLink, (FormSection)phaseAddForm);
        this.connect((FormSection)phaseAddForm);
        this.connect(this.m_phases, 4, (FormSection)phaseEditForm);
        this.connect((FormSection)phaseEditForm, this.m_phases.getRowSelectionModel());
        this.connect(this.m_phases, 5, (FormSection)phaseDeleteForm);
        this.connect((FormSection)phaseDeleteForm, this.m_phases.getRowSelectionModel());
    }

    private boolean hasAdmin(PageState state) {
        return CMS.getContext().getSecurityManager().canAccess(state.getRequest(), "lifecycle_admin");
    }

    public final void reset(PageState state) {
        super.reset(state);
        this.m_phases.clearSelection(state);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class PhaseTable
    extends Table {
        public PhaseTable() {
            super((TableModelBuilder)new PhaseTableModelBuilder(LifecycleItemPane.this.m_cycle), (Object[])s_headers);
            this.setEmptyView((Component)new Label(LifecycleItemPane.gz("cms.ui.lifecycle.phase.none")));
            this.getColumn(4).setCellRenderer((TableCellRenderer)new DefaultTableCellRenderer(true));
            this.getColumn(5).setCellRenderer((TableCellRenderer)new DefaultTableCellRenderer(true));
        }

        public final void register(Page page) {
            super.register(page);
            page.addActionListener(new ActionListener(){

                public final void actionPerformed(ActionEvent e) {
                    PageState state = e.getPageState();
                    boolean hasLifecycleAdmin = LifecycleItemPane.this.hasAdmin(state);
                    this.getColumn(4).setVisible(state, hasLifecycleAdmin);
                    this.getColumn(5).setVisible(state, hasLifecycleAdmin);
                }
            });
        }
    }

    private class PhaseSection
    extends Section {
        public PhaseSection(ActionLink addLink) {
            this.setHeading((Component)new Label(LifecycleItemPane.gz("cms.ui.lifecycle.phases")));
            ActionGroup group = new ActionGroup();
            this.setBody((Component)group);
            group.setSubject((Component)LifecycleItemPane.this.m_phases);
            group.addAction((Component)new LifecycleAdminContainer((Component)addLink), "add");
        }
    }

    private class SummarySection
    extends Section {
        public SummarySection(ActionLink editLink, ActionLink deleteLink) {
            this.setHeading((Component)new Label(LifecycleItemPane.gz("cms.ui.lifecycle.details")));
            ActionGroup group = new ActionGroup();
            this.setBody((Component)group);
            group.setSubject((Component)new Properties());
            group.addAction((Component)new LifecycleAdminContainer((Component)editLink), "edit");
            group.addAction((Component)new LifecycleAdminContainer((Component)deleteLink), "delete");
        }

        private class Properties
        extends PropertyList {
            private Properties() {
            }

            protected final List properties(PageState state) {
                List props = super.properties(state);
                LifecycleDefinition cycle = LifecycleItemPane.this.m_cycle.getLifecycleDefinition(state);
                props.add(new PropertyList.Property(LifecycleItemPane.gz("cms.ui.name"), cycle.getLabel()));
                props.add(new PropertyList.Property(LifecycleItemPane.gz("cms.ui.description"), cycle.getDescription()));
                return props;
            }
        }
    }

    private class SelectionRequestLocal
    extends PhaseRequestLocal {
        private SelectionRequestLocal() {
        }

        protected final Object initialValue(PageState state) {
            String id = LifecycleItemPane.this.m_phases.getRowSelectionModel().getSelectedKey(state).toString();
            return new PhaseDefinition(new BigDecimal(id));
        }
    }
}

