/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.ui.lifecycle;

import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.Table;
import com.arsdigita.bebop.table.AbstractTableModelBuilder;
import com.arsdigita.bebop.table.TableModel;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.lifecycle.Phase;
import com.arsdigita.cms.lifecycle.PhaseCollection;
import com.arsdigita.cms.ui.lifecycle.LifecycleRequestLocal;
import com.arsdigita.cms.util.GlobalizationUtil;
import java.text.DateFormat;
import java.util.Date;

class ItemPhaseTableModelBuilder
extends AbstractTableModelBuilder {
    public static final String versionId = "$Id: //cms/dev/src/com/arsdigita/cms/ui/lifecycle/ItemPhaseTableModelBuilder.java#7 $$Author: dennis $$DateTime: 2004/04/07 16:07:11 $";
    private final LifecycleRequestLocal m_lifecycle;

    public ItemPhaseTableModelBuilder(LifecycleRequestLocal lifecycle) {
        this.m_lifecycle = lifecycle;
    }

    public final TableModel makeModel(Table table, PageState state) {
        return new Model(this.m_lifecycle.getLifecycle(state).getPhases());
    }

    protected static final String lz(String key) {
        return (String)GlobalizationUtil.globalize(key).localize();
    }

    private static class Model
    implements TableModel {
        private final PhaseCollection m_phases;
        private Phase m_phase;

        public Model(PhaseCollection phases) {
            this.m_phases = phases;
        }

        public final int getColumnCount() {
            return 4;
        }

        public final boolean nextRow() {
            if (this.m_phases.next()) {
                this.m_phase = this.m_phases.getPhase();
                return true;
            }
            this.m_phases.close();
            return false;
        }

        public final Object getElementAt(int column) {
            DateFormat format = DateFormat.getDateTimeInstance(0, ContentSection.getConfig().getHideTimezone() ? 3 : 0);
            switch (column) {
                case 0: {
                    return this.m_phase.getLabel();
                }
                case 1: {
                    return this.m_phase.getPhaseDefinition().getDescription();
                }
                case 2: {
                    Date startDate = this.m_phase.getStartDate();
                    return format.format(startDate);
                }
                case 3: {
                    Date endDate = this.m_phase.getEndDate();
                    if (endDate == null) {
                        return ItemPhaseTableModelBuilder.lz("cms.ui.lifecycle.forever");
                    }
                    return format.format(endDate);
                }
            }
            throw new IllegalArgumentException();
        }

        public final Object getKeyAt(int column) {
            return this.m_phase.getPhaseDefinition().getID();
        }
    }
}

