/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.ui.lifecycle;

import com.arsdigita.bebop.BoxPanel;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.bebop.event.FormInitListener;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.FormValidationListener;
import com.arsdigita.bebop.event.ParameterListener;
import com.arsdigita.bebop.event.PrintEvent;
import com.arsdigita.bebop.event.PrintListener;
import com.arsdigita.bebop.form.Date;
import com.arsdigita.bebop.form.Option;
import com.arsdigita.bebop.form.SingleSelect;
import com.arsdigita.bebop.form.Submit;
import com.arsdigita.bebop.form.TextField;
import com.arsdigita.bebop.parameters.BigDecimalParameter;
import com.arsdigita.bebop.parameters.DateParameter;
import com.arsdigita.bebop.parameters.IntegerParameter;
import com.arsdigita.bebop.parameters.NumberInRangeValidationListener;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.cms.CMS;
import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.ContentTypeLifecycleDefinition;
import com.arsdigita.cms.dispatcher.Utilities;
import com.arsdigita.cms.lifecycle.Lifecycle;
import com.arsdigita.cms.lifecycle.LifecycleDefinition;
import com.arsdigita.cms.lifecycle.LifecycleDefinitionCollection;
import com.arsdigita.cms.lifecycle.Phase;
import com.arsdigita.cms.lifecycle.PhaseCollection;
import com.arsdigita.cms.lifecycle.PhaseDefinitionCollection;
import com.arsdigita.cms.ui.BaseForm;
import com.arsdigita.cms.ui.item.ContentItemRequestLocal;
import com.arsdigita.cms.ui.item.ItemWorkflowRequestLocal;
import com.arsdigita.cms.ui.workflow.WorkflowRequestLocal;
import com.arsdigita.cms.util.GlobalizationUtil;
import com.arsdigita.cms.workflow.CMSTask;
import com.arsdigita.kernel.User;
import com.arsdigita.util.Assert;
import com.arsdigita.util.UncheckedWrapperException;
import com.arsdigita.web.RedirectSignal;
import com.arsdigita.web.URL;
import com.arsdigita.web.Web;
import com.arsdigita.workflow.simple.Engine;
import com.arsdigita.workflow.simple.TaskException;
import com.arsdigita.workflow.simple.Workflow;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.Iterator;
import java.util.TooManyListenersException;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

class ItemLifecycleSelectForm
extends BaseForm {
    public static final String versionId = "$Id: //cms/dev/src/com/arsdigita/cms/ui/lifecycle/ItemLifecycleSelectForm.java#25 $$Author: dennis $$DateTime: 2004/04/07 16:07:11 $";
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$cms$ui$lifecycle$ItemLifecycleSelectForm == null ? (class$com$arsdigita$cms$ui$lifecycle$ItemLifecycleSelectForm = ItemLifecycleSelectForm.class$("com.arsdigita.cms.ui.lifecycle.ItemLifecycleSelectForm")) : class$com$arsdigita$cms$ui$lifecycle$ItemLifecycleSelectForm));
    private static final String LIFECYCLE = "lifecycle";
    private static final String START_DATE = "start_date";
    private static final String END_DATE = "end_date";
    private static final String NOTIFICATION_DAYS = "notifyDays";
    private static final String NOTIFICATION_HOURS = "notifyHours";
    private final ContentItemRequestLocal m_item;
    private final WorkflowRequestLocal m_workflow;
    private final SingleSelect m_cycleSelect;
    private final Date m_startDate;
    private final TextField m_startHour;
    private final TextField m_startMinute;
    private final SingleSelect m_startAmpm;
    private final Date m_endDate;
    private final TextField m_endHour;
    private final TextField m_endMinute;
    private final SingleSelect m_endAmpm;
    private TextField m_notificationDays;
    private TextField m_notificationHours;
    static /* synthetic */ Class class$com$arsdigita$cms$ui$lifecycle$ItemLifecycleSelectForm;

    public ItemLifecycleSelectForm(ContentItemRequestLocal item) {
        super("PublishItem", ItemLifecycleSelectForm.gz("cms.ui.item.lifecycle.apply"));
        this.m_item = item;
        this.m_workflow = new ItemWorkflowRequestLocal();
        this.m_cycleSelect = new SingleSelect((ParameterModel)new BigDecimalParameter(LIFECYCLE));
        try {
            this.m_cycleSelect.addPrintListener((PrintListener)new OptionPrinter());
        }
        catch (TooManyListenersException tmle) {
            throw new UncheckedWrapperException((Throwable)tmle);
        }
        this.addField(ItemLifecycleSelectForm.gz("cms.ui.item.lifecycle"), (Component)this.m_cycleSelect);
        this.m_startDate = new Date((ParameterModel)new DateParameter(START_DATE){

            protected final Calendar getCalendar(HttpServletRequest sreq) {
                Calendar cal = super.getCalendar(sreq);
                cal.setLenient(false);
                return cal;
            }
        });
        this.addField(ItemLifecycleSelectForm.gz("cms.ui.item.lifecycle.start_date"), (Component)this.m_startDate);
        BoxPanel startTime = new BoxPanel(1);
        this.addField(ItemLifecycleSelectForm.gz("cms.ui.item.lifecycle.start_time"), (Component)startTime);
        this.m_startHour = new TextField((ParameterModel)new IntegerParameter("start_hour"));
        startTime.add((Component)this.m_startHour);
        this.m_startHour.setSize(3);
        this.m_startHour.addValidationListener((ParameterListener)new NumberInRangeValidationListener(1L, 12L));
        this.m_startMinute = new TextField((ParameterModel)new IntegerParameter("start_minute"));
        startTime.add((Component)this.m_startMinute);
        this.m_startMinute.setSize(3);
        this.m_startMinute.addValidationListener((ParameterListener)new NumberInRangeValidationListener(0L, 59L));
        this.m_startAmpm = new SingleSelect((ParameterModel)new IntegerParameter("start_ampm"));
        startTime.add((Component)this.m_startAmpm);
        this.m_startAmpm.addOption(new Option("0", "am"));
        this.m_startAmpm.addOption(new Option("1", "pm"));
        startTime.add((Component)new Label((PrintListener)new TimeZonePrinter()));
        this.m_endDate = new Date((ParameterModel)new DateParameter(END_DATE){

            protected final Calendar getCalendar(HttpServletRequest sreq) {
                Calendar cal = super.getCalendar(sreq);
                cal.setLenient(false);
                return cal;
            }
        });
        this.addField(ItemLifecycleSelectForm.gz("cms.ui.item.lifecycle.end_date"), (Component)this.m_endDate);
        BoxPanel endTime = new BoxPanel(1);
        this.addField(ItemLifecycleSelectForm.gz("cms.ui.item.lifecycle.end_time"), (Component)endTime);
        this.m_endHour = new TextField((ParameterModel)new IntegerParameter("end_hour"));
        endTime.add((Component)this.m_endHour);
        this.m_endHour.setSize(3);
        this.m_endHour.addValidationListener((ParameterListener)new NumberInRangeValidationListener(1L, 12L));
        this.m_endMinute = new TextField((ParameterModel)new IntegerParameter("end_minute"));
        endTime.add((Component)this.m_endMinute);
        this.m_endMinute.setSize(3);
        this.m_endMinute.addValidationListener((ParameterListener)new NumberInRangeValidationListener(0L, 59L));
        this.m_endAmpm = new SingleSelect((ParameterModel)new IntegerParameter("end_ampm"));
        endTime.add((Component)this.m_endAmpm);
        this.m_endAmpm.addOption(new Option("0", "am"));
        this.m_endAmpm.addOption(new Option("1", "pm"));
        endTime.add((Component)new Label((PrintListener)new TimeZonePrinter()));
        this.m_notificationDays = new TextField((ParameterModel)new IntegerParameter(NOTIFICATION_DAYS));
        this.m_notificationDays.setSize(4);
        this.m_notificationHours = new TextField((ParameterModel)new IntegerParameter(NOTIFICATION_HOURS));
        this.m_notificationHours.setSize(4);
        SimpleContainer cont = new SimpleContainer();
        cont.add((Component)this.m_notificationDays);
        cont.add((Component)new Label(GlobalizationUtil.globalize("cms.ui.item.days"), false));
        cont.add((Component)this.m_notificationHours);
        cont.add((Component)new Label(GlobalizationUtil.globalize("cms.ui.item.hours"), false));
        this.addField(ItemLifecycleSelectForm.gz("cms.ui.item.notification_period"), (Component)cont);
        this.addAction(new Submit("finish", ItemLifecycleSelectForm.gz("cms.ui.item.lifecycle.publish")));
        this.addValidationListener(new ValidationListener());
        this.addSecurityListener("publish", this.m_item);
        this.addInitListener(new InitListener());
        this.addProcessListener(new ProcessListener());
    }

    private java.util.Date computeNotificationDate(java.util.Date endDate, int notificationPeriod) {
        if (endDate == null) {
            return null;
        }
        return new java.util.Date(endDate.getTime() - (long)notificationPeriod * 3600000L);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public class TimeZonePrinter
    implements PrintListener {
        public void prepare(PrintEvent e) {
            Label target = (Label)e.getTarget();
            if (ContentSection.getConfig().getHideTimezone()) {
                target.setLabel("");
            } else {
                PageState state = e.getPageState();
                Calendar mStart = Calendar.getInstance();
                java.util.Date st = (java.util.Date)ItemLifecycleSelectForm.this.m_startDate.getValue(state);
                if (st != null) {
                    mStart.setTime((java.util.Date)ItemLifecycleSelectForm.this.m_startDate.getValue(state));
                }
                String zone = mStart.getTimeZone().getDisplayName(true, 0);
                target.setLabel(zone);
            }
        }
    }

    private class ValidationListener
    implements FormValidationListener {
        private ValidationListener() {
        }

        public void validate(FormSectionEvent e) throws FormProcessException {
            PageState state = e.getPageState();
            Integer startHour = (Integer)ItemLifecycleSelectForm.this.m_startHour.getValue(state);
            if (startHour == null) {
                throw new FormProcessException(ItemLifecycleSelectForm.lz("cms.ui.item.start_time_incomplete"));
            }
            Integer startMinute = (Integer)ItemLifecycleSelectForm.this.m_startMinute.getValue(state);
            if (startMinute == null) {
                startMinute = new Integer(0);
            }
            Integer startAmpm = (Integer)ItemLifecycleSelectForm.this.m_startAmpm.getValue(state);
            java.util.Date startDate = (java.util.Date)ItemLifecycleSelectForm.this.m_startDate.getValue(state);
            if (startDate == null) {
                throw new FormProcessException(ItemLifecycleSelectForm.lz("cms.ui.item.lifecycle.start_date_invalid"));
            }
            java.util.Date nowDate = new java.util.Date(System.currentTimeMillis());
            Calendar cStart = Calendar.getInstance();
            Calendar cNow = Calendar.getInstance();
            cStart.setTime(startDate);
            cNow.setTime(nowDate);
            if (startHour != 12) {
                cStart.set(11, 12 * startAmpm + startHour);
                cStart.set(10, startHour);
            } else if (startAmpm == 0) {
                cStart.set(11, 0);
                cStart.set(10, 0);
            } else {
                cStart.set(11, 12);
                cStart.set(10, 0);
            }
            cStart.set(12, startMinute + 5);
            cStart.set(9, startAmpm);
            cStart.set(13, cNow.get(13));
            cStart.set(14, cNow.get(14));
            if (cNow.after(cStart)) {
                throw new FormProcessException(ItemLifecycleSelectForm.lz("cms.ui.item.lifecycle.start_date_in_past"));
            }
            Integer endHour = (Integer)ItemLifecycleSelectForm.this.m_endHour.getValue(state);
            Integer endMinute = (Integer)ItemLifecycleSelectForm.this.m_endMinute.getValue(state);
            java.util.Date endDate = (java.util.Date)ItemLifecycleSelectForm.this.m_endDate.getValue(state);
            if (endHour == null && (endMinute != null || endDate != null)) {
                throw new FormProcessException(ItemLifecycleSelectForm.lz("cms.ui.item.lifecycle.end_time_incomplete"));
            }
            if (endMinute == null && endHour != null) {
                endMinute = new Integer(0);
            }
            boolean timeBlank = endHour == null && endMinute == null;
            Integer endAmpm = (Integer)ItemLifecycleSelectForm.this.m_endAmpm.getValue(state);
            if (endDate == null && !timeBlank) {
                throw new FormProcessException(ItemLifecycleSelectForm.lz("cms.ui.item.lifecycle.end_date_invalid"));
            }
            if (endDate != null) {
                Calendar cEnd = Calendar.getInstance();
                cEnd.setTime(endDate);
                if (endHour != 12) {
                    cEnd.set(11, 12 * endAmpm + endHour);
                    cEnd.set(10, endHour);
                } else if (endAmpm == 0) {
                    cEnd.set(11, 0);
                    cEnd.set(10, 0);
                } else {
                    cEnd.set(11, 12);
                    cEnd.set(10, 0);
                }
                cEnd.set(12, endMinute + 5);
                cEnd.set(9, endAmpm);
                cEnd.set(13, cNow.get(13));
                cEnd.set(14, cNow.get(14));
                Integer notificationDays = (Integer)ItemLifecycleSelectForm.this.m_notificationDays.getValue(state);
                Integer notificationHours = (Integer)ItemLifecycleSelectForm.this.m_notificationHours.getValue(state);
                int notificationPeriod = 0;
                if (notificationDays != null) {
                    notificationPeriod += notificationDays * 24;
                }
                if (notificationHours != null) {
                    notificationPeriod += notificationHours.intValue();
                }
                if (notificationPeriod > 0) {
                    java.util.Date notificationDate = ItemLifecycleSelectForm.this.computeNotificationDate(cEnd.getTime(), notificationPeriod);
                    s_log.debug((Object)("cStart (Date): " + cStart.getTime()));
                    s_log.debug((Object)("notificationDate: " + notificationDate));
                    if (notificationDate.before(cStart.getTime())) {
                        s_log.debug((Object)"notification date is before start date!");
                        String errorMessage = (String)GlobalizationUtil.globalize("cms.ui.item.notification_period_before_start").localize();
                        throw new FormProcessException(errorMessage);
                    }
                    s_log.debug((Object)"notification date is after start date, OK");
                }
            }
        }
    }

    private class FinishTaskListener
    implements FormProcessListener {
        private FinishTaskListener() {
        }

        public final void process(FormSectionEvent e) throws FormProcessException {
        }
    }

    private class ProcessListener
    implements FormProcessListener {
        private ProcessListener() {
        }

        public final void process(FormSectionEvent e) throws FormProcessException {
            PageState state = e.getPageState();
            Integer startHour = (Integer)ItemLifecycleSelectForm.this.m_startHour.getValue(state);
            Integer startMinute = (Integer)ItemLifecycleSelectForm.this.m_startMinute.getValue(state);
            if (startMinute == null) {
                startMinute = new Integer(0);
            }
            Integer startAmpm = (Integer)ItemLifecycleSelectForm.this.m_startAmpm.getValue(state);
            Integer endHour = (Integer)ItemLifecycleSelectForm.this.m_endHour.getValue(state);
            Integer endMinute = (Integer)ItemLifecycleSelectForm.this.m_endMinute.getValue(state);
            if (endMinute == null) {
                endMinute = new Integer(0);
            }
            Integer endAmpm = (Integer)ItemLifecycleSelectForm.this.m_endAmpm.getValue(state);
            ContentItem item = ItemLifecycleSelectForm.this.m_item.getContentItem(state);
            BigDecimal defID = (BigDecimal)ItemLifecycleSelectForm.this.m_cycleSelect.getValue(state);
            Assert.assertNotNull((Object)defID);
            LifecycleDefinition cycleDef = new LifecycleDefinition(defID);
            java.util.Date startDate = (java.util.Date)ItemLifecycleSelectForm.this.m_startDate.getValue(state);
            Calendar start = Calendar.getInstance();
            start.setTime(startDate);
            start.set(9, startAmpm);
            start.set(12, startMinute);
            start.set(9, startAmpm);
            if (startHour != 12) {
                start.set(11, 12 * startAmpm + startHour);
                start.set(10, startHour);
            } else if (startAmpm == 0) {
                start.set(11, 0);
                start.set(10, 0);
            } else {
                start.set(11, 12);
                start.set(10, 0);
            }
            startDate = start.getTime();
            java.util.Date endDate = (java.util.Date)ItemLifecycleSelectForm.this.m_endDate.getValue(state);
            if (endDate != null) {
                Calendar end = Calendar.getInstance();
                end.setTime(endDate);
                end.set(9, endAmpm);
                end.set(12, endMinute);
                end.set(9, endAmpm);
                if (endHour != 12) {
                    end.set(11, 12 * endAmpm + endHour);
                    end.set(10, endHour);
                } else if (endAmpm == 0) {
                    end.set(11, 0);
                    end.set(10, 0);
                } else {
                    end.set(11, 12);
                    end.set(10, 0);
                }
                endDate = end.getTime();
            }
            if (item.isPublished()) {
                item.removeLifecycle(item);
                item.save();
            }
            ContentItem pending = item.publish(cycleDef, startDate);
            if (endDate != null) {
                Lifecycle lifecycle = pending.getLifecycle();
                PhaseCollection phases = lifecycle.getPhases();
                while (phases.next()) {
                    Phase phase = phases.getPhase();
                    java.util.Date thisEnd = phase.getEndDate();
                    if (thisEnd != null && thisEnd.compareTo(endDate) <= 0) continue;
                    phase.setEndDate(endDate);
                    phase.save();
                }
                Integer notificationDays = (Integer)ItemLifecycleSelectForm.this.m_notificationDays.getValue(state);
                Integer notificationHours = (Integer)ItemLifecycleSelectForm.this.m_notificationHours.getValue(state);
                java.util.Date notificationDate = null;
                int notificationPeriod = 0;
                if (notificationDays != null) {
                    notificationPeriod += notificationDays * 24;
                }
                if (notificationHours != null) {
                    notificationPeriod += notificationHours.intValue();
                }
                if (notificationPeriod > 0) {
                    notificationDate = ItemLifecycleSelectForm.this.computeNotificationDate(endDate, notificationPeriod);
                    Phase expirationImminentPhase = lifecycle.addCustomPhase("expirationImminent", new Long(notificationDate.getTime()), new Long(endDate.getTime()));
                    expirationImminentPhase.setListenerClassName("com.arsdigita.cms.lifecycle.NotifyLifecycleListener");
                    expirationImminentPhase.save();
                }
            }
            pending.getLifecycle().start();
            item.save();
            Workflow workflow = ItemLifecycleSelectForm.this.m_workflow.getWorkflow(state);
            if (workflow != null) {
                Engine engine = Engine.getInstance();
                User user = Web.getContext().getUser();
                Iterator iter = engine.getEnabledTasks(user, workflow.getID()).iterator();
                while (iter.hasNext()) {
                    CMSTask task = (CMSTask)((Object)iter.next());
                    if (!task.getTaskType().equals(CMSTask.DEPLOY)) continue;
                    s_log.debug((Object)("Found DEPLOY task, ID=" + CMSTask.DEPLOY));
                    try {
                        task.finish(user);
                    }
                    catch (TaskException te) {
                        throw new FormProcessException((Throwable)te);
                    }
                }
            }
            if (ContentSection.getConfig().getUseStreamlinedCreation()) {
                throw new RedirectSignal(URL.there((HttpServletRequest)state.getRequest(), (String)Utilities.getWorkspaceURL()), true);
            }
        }
    }

    private class InitListener
    implements FormInitListener {
        private InitListener() {
        }

        public final void init(FormSectionEvent e) {
            PageState state = e.getPageState();
            ContentItem item = ItemLifecycleSelectForm.this.m_item.getContentItem(state);
            if (item.isPublished()) {
                LifecycleDefinition ld = item.getLifecycle().getLifecycleDefinition();
                ItemLifecycleSelectForm.this.m_cycleSelect.setValue(state, (Object)ld.getID());
            } else {
                ContentSection section = CMS.getContext().getContentSection();
                LifecycleDefinition ld = ContentTypeLifecycleDefinition.getLifecycleDefinition(section, item.getContentType());
                if (ld != null) {
                    ItemLifecycleSelectForm.this.m_cycleSelect.setValue(state, (Object)ld.getID());
                }
            }
            java.util.Date start = new java.util.Date(System.currentTimeMillis());
            ItemLifecycleSelectForm.this.m_startDate.setValue(state, (Object)start);
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(start);
            if (calendar.get(10) == 0) {
                ItemLifecycleSelectForm.this.m_startHour.setValue(state, (Object)new Integer(12));
            } else {
                ItemLifecycleSelectForm.this.m_startHour.setValue(state, (Object)new Integer(calendar.get(10)));
            }
            Integer min = new Integer(calendar.get(12));
            if (min < 10) {
                ItemLifecycleSelectForm.this.m_startMinute.setValue(state, (Object)("0" + min.toString()));
            } else {
                ItemLifecycleSelectForm.this.m_startMinute.setValue(state, (Object)min.toString());
            }
            ItemLifecycleSelectForm.this.m_startAmpm.setValue(state, (Object)new Integer(calendar.get(9)));
            BigInteger[] defaultTime = BigInteger.valueOf(ContentSection.getConfig().getDefaultNotificationTime()).divideAndRemainder(BigInteger.valueOf(24L));
            ItemLifecycleSelectForm.this.m_notificationDays.setValue(state, (Object)new Integer(defaultTime[0].intValue()));
            ItemLifecycleSelectForm.this.m_notificationHours.setValue(state, (Object)new Integer(defaultTime[1].intValue()));
        }
    }

    private class OptionPrinter
    implements PrintListener {
        private OptionPrinter() {
        }

        public final void prepare(PrintEvent e) {
            ContentSection section = CMS.getContext().getContentSection();
            LifecycleDefinitionCollection ldc = section.getLifecycleDefinitions();
            ldc.addOrder("label");
            SingleSelect target = (SingleSelect)e.getTarget();
            while (ldc.next()) {
                LifecycleDefinition ld = ldc.getLifecycleDefinition();
                PhaseDefinitionCollection pdc = ld.getPhaseDefinitions();
                if (!pdc.isEmpty()) {
                    target.addOption(new Option(ld.getID().toString(), ld.getLabel()));
                }
                pdc.close();
            }
            ldc.close();
        }
    }
}

