/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.ui.category;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Grid;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.Link;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.RequestLocal;
import com.arsdigita.bebop.SingleSelectionModel;
import com.arsdigita.bebop.Table;
import com.arsdigita.bebop.list.ListModelBuilder;
import com.arsdigita.bebop.table.TableCellRenderer;
import com.arsdigita.categorization.Category;
import com.arsdigita.cms.CMS;
import com.arsdigita.cms.ContentPage;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.ContentType;
import com.arsdigita.cms.dispatcher.ItemResolver;
import com.arsdigita.cms.ui.CMSContainer;
import com.arsdigita.cms.util.GlobalizationUtil;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.kernel.KernelHelper;
import com.arsdigita.kernel.User;
import com.arsdigita.kernel.ui.ACSObjectSelectionModel;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.DataQuery;
import com.arsdigita.persistence.OID;
import com.arsdigita.toolbox.ui.DataQueryListModelBuilder;
import com.arsdigita.util.Assert;
import com.arsdigita.util.Lockable;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public class CategoryItemsBrowser
extends Grid {
    public static final String versionId = "$Id: //cms/dev/src/com/arsdigita/cms/ui/category/CategoryItemsBrowser.java#14 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$cms$ui$category$CategoryItemsBrowser == null ? (class$com$arsdigita$cms$ui$category$CategoryItemsBrowser = CategoryItemsBrowser.class$("com.arsdigita.cms.ui.category.CategoryItemsBrowser")) : class$com$arsdigita$cms$ui$category$CategoryItemsBrowser));
    private RequestLocal m_resolver;
    private String m_context;
    static /* synthetic */ Class class$com$arsdigita$cms$ui$category$CategoryItemsBrowser;

    public CategoryItemsBrowser(ACSObjectSelectionModel sel, int numCols, String context) {
        super(null, numCols);
        super.setModelBuilder((ListModelBuilder)new CategoryItemModelBuilder(sel));
        this.m_context = context;
        this.setRowSelectionModel((SingleSelectionModel)sel);
        this.setEmptyView((Component)new Label(GlobalizationUtil.globalize("cms.ui.category.item.none")));
        this.m_resolver = new RequestLocal(){

            public Object initialValue(PageState s) {
                ContentSection section = CMS.getContext().getContentSection();
                ItemResolver itemResolver = section.getItemResolver();
                s_log.warn((Object)("Item resolver is" + itemResolver.getClass()));
                return itemResolver;
            }
        };
        this.setDefaultCellRenderer(new ItemSummaryCellRenderer());
    }

    public String getContext() {
        return this.m_context;
    }

    public void setContext(String context) {
        Assert.assertNotLocked((Lockable)this);
        this.m_context = context;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class ItemSummaryCellRenderer
    implements TableCellRenderer {
        private ItemSummaryCellRenderer() {
        }

        public Component getComponent(Table table, PageState state, Object value, boolean isSelected, Object key, int row, int column) {
            ContentType t;
            if (value == null) {
                return new Label("&nbsp;", false);
            }
            DomainObject d = DomainObjectFactory.newInstance((DataObject)((DataObject)value));
            Assert.assertTrue((boolean)(d instanceof ContentPage));
            ContentPage p = (ContentPage)d;
            CMSContainer box = new CMSContainer();
            ContentSection section = CMS.getContext().getContentSection();
            ItemResolver resolver = (ItemResolver)CategoryItemsBrowser.this.m_resolver.get(state);
            String url = resolver.generateItemURL(state, p.getID(), p.getName(), section, resolver.getCurrentContext(state));
            Link c = new Link(p.getTitle(), url);
            c.setClassAttr("title");
            box.add((Component)c);
            String summary = p.getSearchSummary();
            if (summary != null && summary.length() > 0) {
                c = new Label(summary);
                c.setClassAttr("summary");
                box.add((Component)c);
            }
            c = (t = p.getContentType()) != null ? new Label(t.getLabel()) : new Label(GlobalizationUtil.globalize("cms.ui.category.item"));
            c.setClassAttr("type");
            box.add((Component)c);
            box.setClassAttr("itemSummary");
            return box;
        }
    }

    private class CategoryItemModelBuilder
    extends DataQueryListModelBuilder {
        private ACSObjectSelectionModel m_sel;

        public CategoryItemModelBuilder(ACSObjectSelectionModel sel) {
            super("page.id", "page");
            this.m_sel = sel;
        }

        public DataQuery getDataQuery(PageState s) {
            Category cat = (Category)this.m_sel.getSelectedObject(s);
            ContentSection section = CMS.getContext().getContentSection();
            User user = KernelHelper.getCurrentUser((HttpServletRequest)s.getRequest());
            OID oid = null;
            if (user != null) {
                oid = user.getOID();
            }
            if (cat == null || cat.equals((Object)section.getRootCategory())) {
                return ContentPage.getPagesInSectionQuery(section, CategoryItemsBrowser.this.getContext(), oid);
            }
            return ContentPage.getPagesInSectionQuery(section, CategoryItemsBrowser.this.getContext(), cat, oid);
        }
    }
}

