/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.ui.category;

import com.arsdigita.bebop.ActionLink;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Container;
import com.arsdigita.bebop.FormSection;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.bebop.SingleSelectionModel;
import com.arsdigita.bebop.event.ActionEvent;
import com.arsdigita.bebop.event.ActionListener;
import com.arsdigita.bebop.event.ChangeEvent;
import com.arsdigita.bebop.event.ChangeListener;
import com.arsdigita.bebop.event.FormSubmissionListener;
import com.arsdigita.bebop.form.Submit;
import com.arsdigita.categorization.CategorizedCollection;
import com.arsdigita.categorization.Category;
import com.arsdigita.categorization.CategoryNotFoundException;
import com.arsdigita.cms.dispatcher.AccessDeniedException;
import com.arsdigita.cms.ui.BaseItemPane;
import com.arsdigita.cms.ui.CMSForm;
import com.arsdigita.cms.ui.VisibilityComponent;
import com.arsdigita.cms.ui.category.CategorizedObjectsList;
import com.arsdigita.cms.ui.category.CategoryLinks;
import com.arsdigita.cms.ui.category.CategoryRequestLocal;
import com.arsdigita.cms.ui.category.IndexItemSelectionForm;
import com.arsdigita.cms.ui.category.LinkForm;
import com.arsdigita.cms.ui.category.SubcategoryList;
import com.arsdigita.cms.ui.permissions.CMSPermissionsPane;
import com.arsdigita.cms.ui.templates.CategoryTemplates;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.kernel.permissions.ObjectPermissionCollection;
import com.arsdigita.kernel.permissions.PermissionDescriptor;
import com.arsdigita.kernel.permissions.PermissionService;
import com.arsdigita.kernel.permissions.PrivilegeDescriptor;
import com.arsdigita.kernel.ui.ACSObjectSelectionModel;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.OID;
import com.arsdigita.toolbox.ui.ActionGroup;
import com.arsdigita.toolbox.ui.ModalPanel;
import com.arsdigita.toolbox.ui.PropertyList;
import com.arsdigita.toolbox.ui.Section;
import com.arsdigita.util.Assert;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;

class CategoryItemPane
extends BaseItemPane {
    public static final String versionId = "$Id: //cms/dev/src/com/arsdigita/cms/ui/category/CategoryItemPane.java#24 $$Author: dennis $$DateTime: 2004/04/07 16:07:11 $";
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$cms$ui$category$CategoryItemPane == null ? (class$com$arsdigita$cms$ui$category$CategoryItemPane = CategoryItemPane.class$("com.arsdigita.cms.ui.category.CategoryItemPane")) : class$com$arsdigita$cms$ui$category$CategoryItemPane));
    private final SingleSelectionModel m_model;
    private final CategoryRequestLocal m_category;
    private final SimpleContainer m_detailPane;
    static /* synthetic */ Class class$com$arsdigita$cms$ui$category$CategoryItemPane;

    public CategoryItemPane(SingleSelectionModel model, CategoryRequestLocal category, ActionLink addLink, ActionLink editLink, ActionLink deleteLink) {
        this.m_model = model;
        this.m_category = category;
        this.m_detailPane = new SimpleContainer();
        this.add((Component)this.m_detailPane);
        this.setDefault((Component)this.m_detailPane);
        ActionLink orderItemsLink = new ActionLink((Component)new Label(CategoryItemPane.gz("cms.ui.category.categorized_objects"))){

            public boolean isVisible(PageState state) {
                if (!super.isVisible(state)) {
                    return false;
                }
                CategorizedCollection items = CategoryItemPane.this.m_category.getCategory(state).getObjects("com.arsdigita.cms.ContentItem");
                items.addEqualsFilter("version", (Object)"live");
                boolean canOrder = items.size() > 1L;
                items.close();
                return canOrder;
            }
        };
        OrderItemsForm orderItemsForm = new OrderItemsForm(this.m_category);
        this.add((Component)orderItemsForm);
        ActionLink indexLink = new ActionLink((Component)new Label(CategoryItemPane.gz("cms.ui.category.change_index_item")));
        IndexItemSelectionForm indexForm = new IndexItemSelectionForm(this.m_category);
        this.add((Component)indexForm);
        this.m_detailPane.add((Component)new SummarySection(editLink, deleteLink, indexLink, orderItemsLink));
        this.m_detailPane.add((Component)new SubcategorySection(addLink));
        ActionLink linkAddLink = new ActionLink((Component)new Label(CategoryItemPane.gz("cms.ui.category.linked.add")));
        LinkForm linkForm = new LinkForm(this.m_category);
        this.add((Component)linkForm);
        linkAddLink.addActionListener((ActionListener)new ModalPanel.NavigationListener((ModalPanel)this, (Component)linkForm));
        linkForm.addSubmissionListener((FormSubmissionListener)new ModalPanel.CancelListener((ModalPanel)this, (FormSection)linkForm));
        this.m_detailPane.add((Component)new LinkedCategorySection(linkAddLink));
        this.m_detailPane.add((Component)new AdminVisible((Component)new CategoryTemplateSection()));
        this.m_detailPane.add((Component)new PermissionsSection());
        this.connect(indexLink, (FormSection)indexForm);
        this.connect((FormSection)indexForm);
        this.connect(orderItemsLink, (FormSection)orderItemsForm);
        this.connect((FormSection)orderItemsForm);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class OrderItemsForm
    extends CMSForm {
        public OrderItemsForm(CategoryRequestLocal category) {
            super("orderItems", (Container)new SimpleContainer());
            Label header = new Label(CategoryItemPane.gz("cms.ui.category.categorized_objects"));
            header.setFontWeight("b");
            this.add((Component)header);
            this.add((Component)new CategorizedObjectsList(category));
            this.add((Component)new Submit("Done"));
        }
    }

    private class PermissionsSection
    extends Section {
        public boolean isVisible(PageState ps) {
            Category cat = CategoryItemPane.this.m_category.getCategory(ps);
            return !cat.isRoot() && cat.canAdmin();
        }

        PermissionsSection() {
            this.setHeading((Component)new Label(CategoryItemPane.gz("cms.ui.permissions")));
            ActionGroup group = new ActionGroup();
            this.setBody((Component)group);
            PrivilegeDescriptor[] privs = new PrivilegeDescriptor[]{PrivilegeDescriptor.EDIT, Category.MAP_DESCRIPTOR, PrivilegeDescriptor.DELETE, PrivilegeDescriptor.ADMIN};
            HashMap<String, String> privMap = new HashMap<String, String>();
            privMap.put("edit", "Edit");
            privMap.put("delete", "Delete");
            privMap.put(Category.MAP_DESCRIPTOR.getName(), "Categorize Items");
            privMap.put("admin", "Admin");
            CMSPermissionsPane permPane = new CMSPermissionsPane(this, privs, privMap, new ACSObjectSelectionModel(CategoryItemPane.this.m_model)){
                private final /* synthetic */ PermissionsSection this$1;
                {
                    this.this$1 = this$1;
                }

                public void showAdmin(PageState ps) {
                    Assert.exists((Object)CategoryItemPane.access$1500(PermissionsSection.access$1900(this.this$1)).getSelectedKey(ps));
                    super.showAdmin(ps);
                    this.getAdminListingPanel().setVisible(ps, false);
                }
            };
            ActionLink restoreDefault = new ActionLink(this, (Component)new Label(CategoryItemPane.gz("cms.ui.restore_default_permissions"))){
                private final /* synthetic */ PermissionsSection this$1;
                {
                    this.this$1 = this$1;
                }

                public boolean isVisible(PageState ps) {
                    Category cat = CategoryItemPane.access$000(PermissionsSection.access$1900(this.this$1)).getCategory(ps);
                    return PermissionService.getContext((ACSObject)cat) == null;
                }
            };
            ActionLink useCustom = new ActionLink(this, (Component)new Label(CategoryItemPane.gz("cms.ui.use_custom_permissions"))){
                private final /* synthetic */ PermissionsSection this$1;
                {
                    this.this$1 = this$1;
                }

                public boolean isVisible(PageState ps) {
                    Category cat = CategoryItemPane.access$000(PermissionsSection.access$1900(this.this$1)).getCategory(ps);
                    return PermissionService.getContext((ACSObject)cat) != null;
                }
            };
            ActionListener al = new ActionListener(this, permPane){
                private final /* synthetic */ CMSPermissionsPane val$permPane;
                private final /* synthetic */ PermissionsSection this$1;
                {
                    this.this$1 = this$1;
                    this.val$permPane = val$permPane;
                }

                public void actionPerformed(ActionEvent event) {
                    PageState state = event.getPageState();
                    Category cat = CategoryItemPane.access$000(PermissionsSection.access$1900(this.this$1)).getCategory(state);
                    if (!cat.canAdmin()) {
                        throw new AccessDeniedException();
                    }
                    DataObject context = PermissionService.getContext((ACSObject)cat);
                    if (context != null) {
                        PermissionService.clonePermissions((ACSObject)cat);
                    } else {
                        Category parent;
                        try {
                            parent = cat.getDefaultParentCategory();
                        }
                        catch (CategoryNotFoundException ce) {
                            throw new IllegalStateException("link shouldn't exist for root categories");
                        }
                        PermissionService.setContext((ACSObject)cat, (ACSObject)parent);
                        ObjectPermissionCollection perms = PermissionService.getDirectGrantedPermissions((OID)cat.getOID());
                        while (perms.next()) {
                            PermissionService.revokePermission((PermissionDescriptor)new PermissionDescriptor(perms.getPrivilege(), cat.getOID(), perms.getGranteeOID()));
                        }
                    }
                    this.val$permPane.reset(state);
                }
            };
            restoreDefault.addActionListener(al);
            useCustom.addActionListener(al);
            SimpleContainer links = new SimpleContainer();
            links.add((Component)restoreDefault);
            links.add((Component)useCustom);
            group.setSubject((Component)permPane);
            group.addAction((Component)links);
            CategoryItemPane.this.m_model.addChangeListener(new ChangeListener(this){
                private final /* synthetic */ PermissionsSection this$1;
                {
                    this.this$1 = this$1;
                }

                public void stateChanged(ChangeEvent e) {
                    PageState ps = e.getPageState();
                }
            });
        }

        static /* synthetic */ CategoryItemPane access$1900(PermissionsSection x0) {
            return x0.CategoryItemPane.this;
        }
    }

    private class CategoryTemplateSection
    extends Section {
        CategoryTemplateSection() {
            this.setHeading((Component)new Label(CategoryItemPane.gz("cms.ui.category.templates")));
            ActionGroup group = new ActionGroup();
            this.setBody((Component)group);
            group.setSubject((Component)new CategoryTemplates(CategoryItemPane.this.m_category));
        }
    }

    private class LinkedCategorySection
    extends Section {
        LinkedCategorySection(ActionLink linkAddLink) {
            this.setHeading((Component)new Label(CategoryItemPane.gz("cms.ui.category.linked")));
            ActionGroup group = new ActionGroup();
            this.setBody((Component)group);
            group.setSubject((Component)new CategoryLinks(CategoryItemPane.this.m_category, CategoryItemPane.this.m_model));
            group.addAction((Component)new EditVisible((Component)linkAddLink), "edit");
        }

        public final boolean isVisible(PageState state) {
            return !CategoryItemPane.this.m_category.getCategory(state).isRoot();
        }
    }

    private class SubcategorySection
    extends Section {
        SubcategorySection(ActionLink addLink) {
            this.setHeading((Component)new Label(CategoryItemPane.gz("cms.ui.category.subcategories")));
            ActionGroup group = new ActionGroup();
            this.setBody((Component)group);
            group.setSubject((Component)new SubcategoryList(CategoryItemPane.this.m_category, CategoryItemPane.this.m_model));
            group.addAction((Component)new AdminVisible((Component)addLink), "add");
        }
    }

    private class SummarySection
    extends Section {
        SummarySection(ActionLink editLink, ActionLink deleteLink, ActionLink indexLink, ActionLink orderItemsLink) {
            this.setHeading((Component)new Label(CategoryItemPane.gz("cms.ui.category.details")));
            ActionGroup group = new ActionGroup();
            this.setBody((Component)group);
            group.setSubject((Component)new Properties());
            group.addAction((Component)new EditVisible((Component)editLink), "edit");
            group.addAction((Component)new EditVisible((Component)orderItemsLink));
            group.addAction((Component)new EditVisible((Component)indexLink));
            group.addAction((Component)new AdminVisible((Component)deleteLink), "delete");
        }

        private class Properties
        extends PropertyList {
            private Properties() {
            }

            protected final List properties(PageState state) {
                List props = super.properties(state);
                Category category = CategoryItemPane.this.m_category.getCategory(state);
                ACSObject item = category.getDirectIndexObject();
                String itemTitle = "";
                if (item != null) {
                    itemTitle = item.getDisplayName();
                }
                props.add(new PropertyList.Property(CategoryItemPane.gz("cms.ui.name"), category.getName()));
                props.add(new PropertyList.Property(CategoryItemPane.gz("cms.ui.description"), category.getDescription()));
                props.add(new PropertyList.Property(CategoryItemPane.gz("cms.ui.category.url"), category.getURL()));
                props.add(new PropertyList.Property(CategoryItemPane.gz("cms.ui.category.is_not_abstract"), category.isAbstract() ? CategoryItemPane.gz("cms.ui.no") : CategoryItemPane.gz("cms.ui.yes")));
                props.add(new PropertyList.Property(CategoryItemPane.gz("cms.ui.category.is_enabled"), category.isEnabled() ? CategoryItemPane.gz("cms.ui.yes") : CategoryItemPane.gz("cms.ui.no")));
                props.add(new PropertyList.Property(CategoryItemPane.gz("cms.ui.category.index_item"), itemTitle));
                return props;
            }
        }
    }

    private class AdminVisible
    extends VisibilityComponent {
        AdminVisible(Component child) {
            super(child, null);
        }

        public boolean hasPermission(PageState ps) {
            return CategoryItemPane.this.m_category.getCategory(ps).canAdmin();
        }
    }

    private class EditVisible
    extends VisibilityComponent {
        EditVisible(Component child) {
            super(child, null);
        }

        public boolean hasPermission(PageState ps) {
            return CategoryItemPane.this.m_category.getCategory(ps).canEdit();
        }
    }
}

