/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.ui.authoringkit;

import com.arsdigita.bebop.BoxPanel;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.Page;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.bebop.Table;
import com.arsdigita.bebop.ToggleLink;
import com.arsdigita.bebop.event.ActionEvent;
import com.arsdigita.bebop.event.ActionListener;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.FormSubmissionListener;
import com.arsdigita.bebop.event.PrintEvent;
import com.arsdigita.bebop.event.PrintListener;
import com.arsdigita.bebop.event.TableActionEvent;
import com.arsdigita.bebop.event.TableActionListener;
import com.arsdigita.bebop.table.DefaultTableCellRenderer;
import com.arsdigita.bebop.table.TableCellRenderer;
import com.arsdigita.bebop.table.TableModel;
import com.arsdigita.bebop.table.TableModelBuilder;
import com.arsdigita.cms.AuthoringKit;
import com.arsdigita.cms.AuthoringStep;
import com.arsdigita.cms.AuthoringStepCollection;
import com.arsdigita.cms.ContentType;
import com.arsdigita.cms.ui.authoringkit.AddStep;
import com.arsdigita.cms.ui.authoringkit.DeleteStep;
import com.arsdigita.cms.ui.authoringkit.EditKit;
import com.arsdigita.cms.ui.authoringkit.EditStep;
import com.arsdigita.cms.ui.type.ContentTypeRequestLocal;
import com.arsdigita.cms.ui.type.TypeSecurityContainer;
import com.arsdigita.cms.ui.util.ToggleLinkFormListener;
import com.arsdigita.cms.util.GlobalizationUtil;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.globalization.GlobalizedMessage;
import com.arsdigita.util.UncheckedWrapperException;
import com.arsdigita.xml.Element;
import org.apache.log4j.Logger;

public class KitPanel
extends BoxPanel
implements ActionListener,
TableActionListener {
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$cms$ui$authoringkit$KitPanel == null ? (class$com$arsdigita$cms$ui$authoringkit$KitPanel = KitPanel.class$("com.arsdigita.cms.ui.authoringkit.KitPanel")) : class$com$arsdigita$cms$ui$authoringkit$KitPanel));
    public static final String versionId = "$Id: //cms/dev/src/com/arsdigita/cms/ui/authoringkit/KitPanel.java#14 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    public static final Integer EDIT_COLUMN = new Integer(4);
    public static final Integer DELETE_COLUMN = new Integer(5);
    private final ContentTypeRequestLocal m_type;
    private final Table m_stepTable;
    private ToggleLink m_addStep;
    private ToggleLink m_editKit;
    private SimpleContainer m_kitInfo;
    private EditKit m_editKitPanel;
    private AddStep m_addStepPanel;
    private EditStep m_editStepPanel;
    private DeleteStep m_deleteStepPanel;
    static /* synthetic */ Class class$com$arsdigita$cms$ui$authoringkit$KitPanel;

    public KitPanel(ContentTypeRequestLocal type) {
        this.m_type = type;
        SimpleContainer heading = new SimpleContainer();
        heading.add((Component)new Label(GlobalizationUtil.globalize("cms.ui.authoringkit.authoring_kit_for")));
        heading.add((Component)this.makeContentType());
        this.m_editKit = new ToggleLink("edit");
        this.m_editKit.setClassAttr("actionLink");
        this.m_editKit.addActionListener((ActionListener)this);
        this.m_editKitPanel = new EditKit(this.m_type);
        this.m_editKitPanel.addProcessListener(new ToggleLinkFormListener(this.m_editKit));
        this.m_editKitPanel.addSubmissionListener(new FormSubmissionListener(){

            public void submitted(FormSectionEvent event) throws FormProcessException {
                PageState state = event.getPageState();
                if (KitPanel.this.m_editKitPanel.isCancelled(state)) {
                    KitPanel.this.m_addStep.setSelected(state, false);
                    KitPanel.this.m_editKit.setSelected(state, false);
                    KitPanel.this.m_stepTable.clearSelection(state);
                }
            }
        });
        this.m_stepTable = this.makeStepTable();
        this.m_addStep = new ToggleLink("add step");
        this.m_addStep.setClassAttr("actionLink");
        this.m_addStep.addActionListener((ActionListener)this);
        this.m_addStepPanel = new AddStep(this.m_type);
        this.m_addStepPanel.addProcessListener(new ToggleLinkFormListener(this.m_addStep));
        this.m_addStepPanel.addSubmissionListener(new FormSubmissionListener(){

            public void submitted(FormSectionEvent event) throws FormProcessException {
                PageState state = event.getPageState();
                if (KitPanel.this.m_addStepPanel.isCancelled(state)) {
                    KitPanel.this.m_addStep.setSelected(state, false);
                    KitPanel.this.m_editKit.setSelected(state, false);
                    KitPanel.this.m_stepTable.clearSelection(state);
                }
            }
        });
        FormProcessListener clearStepsProcessListener = new FormProcessListener(){

            public void process(FormSectionEvent e) throws FormProcessException {
                PageState s = e.getPageState();
                KitPanel.this.m_stepTable.clearSelection(s);
            }
        };
        FormSubmissionListener clearStepsSubmissionListener = new FormSubmissionListener(){

            public void submitted(FormSectionEvent e) throws FormProcessException {
                PageState s = e.getPageState();
                if (KitPanel.this.m_deleteStepPanel.isCancelled(s)) {
                    KitPanel.this.m_stepTable.clearSelection(s);
                }
            }
        };
        this.m_editStepPanel = new EditStep(this.m_type, this.m_stepTable.getRowSelectionModel());
        this.m_editStepPanel.addProcessListener(clearStepsProcessListener);
        this.m_editStepPanel.addSubmissionListener(new FormSubmissionListener(){

            public void submitted(FormSectionEvent event) throws FormProcessException {
                PageState state = event.getPageState();
                if (KitPanel.this.m_editStepPanel.isCancelled(state)) {
                    KitPanel.this.m_addStep.setSelected(state, false);
                    KitPanel.this.m_editKit.setSelected(state, false);
                    KitPanel.this.m_stepTable.clearSelection(state);
                }
            }
        });
        this.m_deleteStepPanel = new DeleteStep(this.m_stepTable.getRowSelectionModel(), this.m_type);
        this.m_deleteStepPanel.addProcessListener(clearStepsProcessListener);
        this.m_deleteStepPanel.addSubmissionListener(clearStepsSubmissionListener);
        SimpleContainer createComponent = new SimpleContainer();
        createComponent.add((Component)new Label(GlobalizationUtil.globalize("cms.ui.authoringkit.create_component")));
        createComponent.add((Component)this.makeCreateComponent());
        createComponent.add((Component)new TypeSecurityContainer((Component)this.m_editKit));
        this.m_kitInfo = new BoxPanel();
        this.m_kitInfo.add((Component)heading);
        this.m_kitInfo.add((Component)createComponent);
        this.m_kitInfo.add((Component)this.m_stepTable);
        this.m_kitInfo.add((Component)new TypeSecurityContainer((Component)this.m_addStep));
        this.add((Component)this.m_kitInfo);
        this.add((Component)this.m_editKitPanel);
        this.add((Component)this.m_addStepPanel);
        this.add((Component)this.m_editStepPanel);
        this.add((Component)this.m_deleteStepPanel);
    }

    public void reset(PageState s) {
        this.m_addStep.setSelected(s, false);
        this.m_editKit.setSelected(s, false);
        this.m_stepTable.clearSelection(s);
    }

    private Label makeContentType() {
        PrintListener l = new PrintListener(){

            public void prepare(PrintEvent e) {
                Label t = (Label)e.getTarget();
                PageState s = e.getPageState();
                ContentType type = KitPanel.this.m_type.getContentType(s);
                t.setFontWeight("b");
                t.setLabel(type.getLabel());
            }
        };
        return new Label(l);
    }

    private Label makeCreateComponent() {
        PrintListener l = new PrintListener(){

            public void prepare(PrintEvent e) {
                String createComponent;
                Label t = (Label)e.getTarget();
                PageState s = e.getPageState();
                ContentType type = KitPanel.this.m_type.getContentType(s);
                if (type.getAuthoringKit() != null) {
                    createComponent = type.getAuthoringKit().getCreateComponent();
                    if (createComponent == null) {
                        createComponent = "n/a";
                    }
                } else {
                    createComponent = "n/a - This is not a creatable Content Type";
                }
                t.setLabel(createComponent);
            }
        };
        return new Label(l);
    }

    public void actionPerformed(ActionEvent e) {
        PageState s = e.getPageState();
        if (this.m_editKit.isSelected(s)) {
            this.m_addStep.setSelected(s, false);
            this.m_stepTable.clearSelection(s);
        } else if (this.m_addStep.isSelected(s)) {
            this.m_editKit.setSelected(s, false);
            this.m_stepTable.clearSelection(s);
        }
    }

    public void cellSelected(TableActionEvent e) {
        PageState s = e.getPageState();
        if (e.getSource() == this) {
            this.m_editKit.setSelected(s, false);
            this.m_addStep.setSelected(s, false);
        }
    }

    public void headSelected(TableActionEvent e) {
    }

    private Table makeStepTable() {
        Object[] headers = new String[]{"Ordering", "Label", "Description", "Component", "Action", ""};
        TableModelBuilder b = new TableModelBuilder((String[])headers){
            private boolean m_locked;
            private final /* synthetic */ String[] val$headers;
            {
                this.val$headers = val$headers;
            }

            public TableModel makeModel(Table t, PageState s) {
                return new TableModel(this, s){
                    AuthoringKit kit;
                    AuthoringStepCollection steps;
                    AuthoringStep currentStep;
                    private final /* synthetic */ PageState val$s;
                    private final /* synthetic */ 8 this$1;
                    {
                        this.this$1 = this$1;
                        this.val$s = val$s;
                        this.kit = this.getKit();
                        this.steps = this.kit == null ? null : this.kit.getSteps();
                        this.currentStep = null;
                    }

                    private AuthoringKit getKit() {
                        ContentType type = KitPanel.access$700(8.access$800(this.this$1)).getContentType(this.val$s);
                        try {
                            AuthoringKit k = type.getAuthoringKit();
                            return k;
                        }
                        catch (DataObjectNotFoundException e) {
                            throw new UncheckedWrapperException("Authoring kit not found", (Throwable)e);
                        }
                    }

                    public int getColumnCount() {
                        return 8.access$900(this.this$1).length;
                    }

                    public boolean nextRow() {
                        boolean next;
                        if (this.steps == null) {
                            next = false;
                        } else {
                            next = this.steps.next();
                            if (next) {
                                this.currentStep = this.steps.getAuthoringStep();
                            }
                        }
                        return next;
                    }

                    public Object getElementAt(int columnIndex) {
                        if (this.currentStep == null) {
                            throw new IllegalArgumentException((String)GlobalizationUtil.globalize("cms.ui.authoringkit.current_row_does_not_exists").localize());
                        }
                        switch (columnIndex) {
                            case 0: {
                                if (this.kit != null) {
                                    return this.kit.getOrdering(this.currentStep);
                                }
                                return "";
                            }
                            case 1: {
                                if (this.currentStep.getLabelKey() == null) {
                                    return this.currentStep.getLabel();
                                }
                                if (this.currentStep.getLabelBundle() == null) {
                                    return new Label(GlobalizationUtil.globalize(this.currentStep.getLabelKey()));
                                }
                                return new Label(new GlobalizedMessage(this.currentStep.getLabelKey(), this.currentStep.getLabelBundle()));
                            }
                            case 2: {
                                if (this.currentStep.getDescriptionKey() == null) {
                                    return this.currentStep.getDescription();
                                }
                                if (this.currentStep.getDescriptionBundle() == null) {
                                    return new Label(GlobalizationUtil.globalize(this.currentStep.getDescriptionKey()));
                                }
                                return new Label(new GlobalizedMessage(this.currentStep.getDescriptionKey(), this.currentStep.getDescriptionBundle()));
                            }
                            case 3: {
                                return this.currentStep.getComponent();
                            }
                            case 4: {
                                return "edit";
                            }
                            case 5: {
                                return "delete";
                            }
                        }
                        throw new IllegalArgumentException("columnIndex exceeds number of columns available");
                    }

                    public Object getKeyAt(int columnIndex) {
                        if (this.currentStep == null) {
                            throw new IllegalArgumentException((String)GlobalizationUtil.globalize("cms.ui.authoringkit.current_row_does_not_exists").localize());
                        }
                        return this.currentStep.getID();
                    }
                };
            }

            public void lock() {
                this.m_locked = true;
            }

            public boolean isLocked() {
                return this.m_locked;
            }

            static /* synthetic */ KitPanel access$800(8 x0) {
                return x0.KitPanel.this;
            }

            static /* synthetic */ String[] access$900(8 x0) {
                return x0.val$headers;
            }
        };
        Table result = new Table(b, headers);
        result.getColumn(4).setCellRenderer((TableCellRenderer)new KitTableCellRenderer(true));
        result.getColumn(5).setCellRenderer((TableCellRenderer)new KitTableCellRenderer(true));
        return result;
    }

    public Table getStepTable() {
        return this.m_stepTable;
    }

    public void register(Page p) {
        p.addComponent((Component)this);
    }

    public void generateXML(PageState state, Element parent) {
        if (this.m_editKit.isSelected(state)) {
            s_log.debug((Object)"Displaying edit kit panel");
            this.m_editKitPanel.generateXML(state, parent);
        } else if (this.m_addStep.isSelected(state)) {
            s_log.debug((Object)"Displaying add step panel");
            this.m_addStepPanel.generateXML(state, parent);
        } else if (this.m_stepTable.isSelectedColumn(state, (Object)EDIT_COLUMN)) {
            s_log.debug((Object)"Displaying edit step panel");
            this.m_editStepPanel.generateXML(state, parent);
        } else if (this.m_stepTable.isSelectedColumn(state, (Object)DELETE_COLUMN)) {
            s_log.debug((Object)"Displaying delete step panel");
            this.m_deleteStepPanel.generateXML(state, parent);
        } else {
            s_log.debug((Object)"Displaying kit info");
            this.m_kitInfo.generateXML(state, parent);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class KitTableCellRenderer
    extends DefaultTableCellRenderer {
        public KitTableCellRenderer(boolean active) {
            super(active);
        }

        public Component getComponent(Table table, PageState state, Object value, boolean isSelected, Object key, int row, int column) {
            return new TypeSecurityContainer(super.getComponent(table, state, value, isSelected, key, row, column));
        }
    }
}

