/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.ui.authoring;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.RequestLocal;
import com.arsdigita.bebop.SingleSelectionModel;
import com.arsdigita.bebop.event.ActionEvent;
import com.arsdigita.bebop.event.ActionListener;
import com.arsdigita.bebop.form.Option;
import com.arsdigita.bebop.form.SingleSelect;
import com.arsdigita.cms.ItemSelectionModel;
import com.arsdigita.cms.TextAsset;
import com.arsdigita.cms.TextPage;
import com.arsdigita.cms.ui.authoring.AuthoringKitWizard;
import com.arsdigita.cms.ui.authoring.TextAssetBody;
import com.arsdigita.cms.ui.workflow.WorkflowLockedComponentAccess;
import com.arsdigita.cms.util.GlobalizationUtil;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.util.Assert;

public class TextPageBody
extends TextAssetBody {
    public static final String versionId = "$Id: //cms/dev/src/com/arsdigita/cms/ui/authoring/TextPageBody.java#11 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private AuthoringKitWizard m_parent;
    private ItemSelectionModel m_itemModel;

    public TextPageBody(ItemSelectionModel itemModel, AuthoringKitWizard parent) {
        super(new ItemAssetModel(itemModel));
        this.m_itemModel = itemModel;
        this.m_parent = parent;
        parent.getList().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PageState state = e.getPageState();
                TextPageBody.this.reset(state);
            }
        });
        Component f = this.getComponent("file");
        this.setComponentAccess("file", new WorkflowLockedComponentAccess(f, itemModel));
        Component t = this.getComponent("text");
        this.setComponentAccess("text", new WorkflowLockedComponentAccess(t, itemModel));
    }

    protected void setMimeTypeOptions(SingleSelect mimeSelect) {
        mimeSelect.addOption(new Option("text/html", "HTML Text"));
        mimeSelect.setOptionSelected("text/html");
    }

    protected TextAsset createTextAsset(PageState s) {
        TextPage item = this.getTextPage(s);
        TextAsset t = new TextAsset();
        t.setName(item.getName() + "_text_" + item.getID());
        t.setParent((ACSObject)item);
        return t;
    }

    protected void updateTextAsset(PageState s, TextAsset a) {
        TextPage t = this.getTextPage(s);
        Assert.assertNotNull((Object)t);
        a.setParent((ACSObject)t);
        t.setTextAsset(a);
        a.save();
        t.save();
    }

    protected TextPage getTextPage(PageState s) {
        return (TextPage)this.m_itemModel.getSelectedObject(s);
    }

    private static class ItemAssetModel
    extends ItemSelectionModel {
        private RequestLocal m_asset = new RequestLocal(this){
            private final /* synthetic */ ItemAssetModel this$0;
            {
                this.this$0 = this$0;
            }

            protected Object initialValue(PageState s) {
                TextPage t = (TextPage)((ItemSelectionModel)this.this$0.getSingleSelectionModel()).getSelectedObject(s);
                Assert.assertNotNull((Object)t);
                return t.getTextAsset();
            }
        };

        public ItemAssetModel(ItemSelectionModel m) {
            super((SingleSelectionModel)m);
        }

        public Object getSelectedKey(PageState s) {
            TextAsset a = (TextAsset)this.getSelectedObject(s);
            return a == null ? null : a.getID();
        }

        public DomainObject getSelectedObject(PageState s) {
            return (DomainObject)this.m_asset.get(s);
        }

        public void setSelectedObject(PageState s, DomainObject o) {
            this.m_asset.set(s, (Object)o);
        }

        public void setSelectedKey(PageState s, Object key) {
            throw new UnsupportedOperationException((String)GlobalizationUtil.globalize("cms.ui.authoring.not_implemented").localize());
        }

        public boolean isSelected(PageState s) {
            return this.getSelectedObject(s) != null;
        }
    }
}

