/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.ui.authoring;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.FormSubmissionListener;
import com.arsdigita.cms.ContentBundle;
import com.arsdigita.cms.ContentPage;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.ContentType;
import com.arsdigita.cms.Folder;
import com.arsdigita.cms.ItemSelectionModel;
import com.arsdigita.cms.ui.authoring.ApplyWorkflowFormSection;
import com.arsdigita.cms.ui.authoring.BasicPageForm;
import com.arsdigita.cms.ui.authoring.CreationComponent;
import com.arsdigita.cms.ui.authoring.CreationSelector;
import com.arsdigita.cms.ui.authoring.LanguageWidget;
import com.arsdigita.cms.util.GlobalizationUtil;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.util.Assert;
import java.util.Date;
import org.apache.log4j.Logger;

public class PageCreate
extends BasicPageForm
implements FormSubmissionListener,
CreationComponent {
    public static final String versionId = "$Id: //cms/dev/src/com/arsdigita/cms/ui/authoring/PageCreate.java#20 $$Author: dennis $$DateTime: 2004/04/07 16:07:11 $";
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$cms$ui$authoring$PageCreate == null ? (class$com$arsdigita$cms$ui$authoring$PageCreate = PageCreate.class$("com.arsdigita.cms.ui.authoring.PageCreate")) : class$com$arsdigita$cms$ui$authoring$PageCreate));
    private final CreationSelector m_parent;
    private ApplyWorkflowFormSection m_workflowSection;
    public static final String SECTION_ID = "sid";
    static /* synthetic */ Class class$com$arsdigita$cms$ui$authoring$PageCreate;
    static /* synthetic */ Class class$com$arsdigita$cms$ContentSection;

    public PageCreate(ItemSelectionModel itemModel, CreationSelector parent) {
        super("PageCreate", itemModel);
        this.m_parent = parent;
        this.m_workflowSection.setCreationSelector(this.m_parent);
        this.addSubmissionListener(this);
        this.getSaveCancelSection().getSaveButton().setButtonLabel("Create");
    }

    protected void addWidgets() {
        ContentType type = this.getItemSelectionModel().getContentType();
        this.m_workflowSection = new ApplyWorkflowFormSection(type);
        this.add((Component)this.m_workflowSection, 128);
        this.add((Component)new Label(GlobalizationUtil.globalize("cms.ui.authoring.content_type")));
        this.add((Component)new Label(type.getLabel()));
        this.add((Component)new Label(GlobalizationUtil.globalize("cms.ui.language.field")));
        this.add((Component)new LanguageWidget("language"));
        super.addWidgets();
    }

    public ApplyWorkflowFormSection getWorkflowSection() {
        return this.m_workflowSection;
    }

    public void init(FormSectionEvent e) throws FormProcessException {
    }

    public void submitted(FormSectionEvent e) throws FormProcessException {
        PageState state = e.getPageState();
        if (this.getSaveCancelSection().getCancelButton().isSelected(state)) {
            this.m_parent.redirectBack(state);
            throw new FormProcessException((String)GlobalizationUtil.globalize("cms.ui.authoring.submission_cancelled").localize());
        }
    }

    public void validate(FormSectionEvent e) throws FormProcessException {
        Folder f = this.m_parent.getFolder(e.getPageState());
        Assert.assertNotNull((Object)f);
        this.validateNameUniqueness(f, e);
    }

    public void process(FormSectionEvent e) throws FormProcessException {
        FormData data = e.getFormData();
        PageState state = e.getPageState();
        ContentSection section = this.m_parent.getContentSection(state);
        Folder folder = this.m_parent.getFolder(state);
        Assert.exists((Object)((Object)section), (Class)(class$com$arsdigita$cms$ContentSection == null ? (class$com$arsdigita$cms$ContentSection = PageCreate.class$("com.arsdigita.cms.ContentSection")) : class$com$arsdigita$cms$ContentSection));
        ContentPage item = this.createContentPage(state);
        item.setLanguage((String)data.get((Object)"language"));
        item.setName((String)data.get((Object)"name"));
        item.setTitle((String)data.get((Object)"title"));
        if (!ContentSection.getConfig().getHideLaunchDate()) {
            item.setLaunchDate((Date)data.get((Object)"launchDate"));
        }
        ContentBundle bundle = new ContentBundle(item);
        bundle.setParent((ACSObject)folder);
        bundle.setContentSection(this.m_parent.getContentSection(state));
        bundle.save();
        this.m_workflowSection.applyWorkflow(state, item);
        this.m_parent.editItem(state, item);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

