/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.ui.authoring;

import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.RequestLocal;
import com.arsdigita.categorization.Category;
import com.arsdigita.categorization.CategoryCollection;
import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.ItemSelectionModel;
import com.arsdigita.persistence.DataQuery;
import com.arsdigita.persistence.SessionManager;
import java.math.BigDecimal;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;
import org.apache.log4j.Logger;

public class CategoryModelBuilder {
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$cms$ui$authoring$CategoryModelBuilder == null ? (class$com$arsdigita$cms$ui$authoring$CategoryModelBuilder = CategoryModelBuilder.class$("com.arsdigita.cms.ui.authoring.CategoryModelBuilder")) : class$com$arsdigita$cms$ui$authoring$CategoryModelBuilder));
    private Category m_root;
    private ItemSelectionModel m_item;
    private RequestLocal m_assigned;
    private RequestLocal m_unassigned;
    private RequestLocal m_loaded;
    static /* synthetic */ Class class$com$arsdigita$cms$ui$authoring$CategoryModelBuilder;

    public CategoryModelBuilder(Category root, ItemSelectionModel item) {
        this.m_item = item;
        this.m_root = root;
        this.m_root.disconnect();
        this.m_assigned = new RequestLocal();
        this.m_unassigned = new RequestLocal();
        this.m_loaded = new RequestLocal();
    }

    public Map getUnassignedCategories(PageState state) {
        if (!Boolean.TRUE.equals(this.m_loaded.get(state))) {
            this.loadCategories(state);
        }
        return (Map)this.m_unassigned.get(state);
    }

    public Map getAssignedCategories(PageState state) {
        if (!Boolean.TRUE.equals(this.m_loaded.get(state))) {
            this.loadCategories(state);
        }
        return (Map)this.m_assigned.get(state);
    }

    private void loadCategories(PageState state) {
        TreeMap<CategoryKey, String> unassigned = new TreeMap<CategoryKey, String>(new CategoryCollator());
        TreeMap<CategoryKey, String> assigned = new TreeMap<CategoryKey, String>(new CategoryCollator());
        HashSet<BigDecimal> initial = new HashSet<BigDecimal>();
        ContentItem item = (ContentItem)this.m_item.getSelectedObject(state);
        CategoryCollection cursor = item.getCategoryCollection();
        while (cursor.next()) {
            Category c = cursor.getCategory();
            initial.add(c.getID());
        }
        cursor.close();
        DataQuery cats = SessionManager.getSession().retrieveQuery("com.arsdigita.categorization.getAllCategoryChildren");
        cats.setParameter("id", (Object)this.m_root.getID());
        HashMap<Object, ArrayList<Object[]>> childrenMap = new HashMap<Object, ArrayList<Object[]>>();
        while (cats.next()) {
            Object[] cat = new Object[]{cats.get("id"), cats.get("name")};
            ArrayList<Object[]> children = (ArrayList<Object[]>)childrenMap.get(cats.get("parentID"));
            if (children == null) {
                children = new ArrayList<Object[]>();
                childrenMap.put(cats.get("parentID"), children);
            }
            children.add(cat);
        }
        LinkedList<BigDecimal> queue = new LinkedList<BigDecimal>();
        LinkedList<String> nameQueue = new LinkedList<String>();
        queue.addLast(this.m_root.getID());
        if (this.m_root.isAbstract()) {
            nameQueue.addLast("");
        } else {
            nameQueue.addLast(this.m_root.getName());
        }
        while (!queue.isEmpty()) {
            ArrayList children;
            BigDecimal id = (BigDecimal)queue.removeFirst();
            String name = (String)nameQueue.removeFirst();
            if (name != null && !"".equals(name)) {
                if (initial.contains(id)) {
                    assigned.put(new CategoryKey(id, name), name);
                } else {
                    unassigned.put(new CategoryKey(id, name), name);
                }
            }
            if ((children = (ArrayList)childrenMap.get(id)) == null) continue;
            Iterator i = children.iterator();
            while (i.hasNext()) {
                Object[] child = (Object[])i.next();
                BigDecimal childID = (BigDecimal)child[0];
                String childName = (String)child[1];
                queue.addLast(childID);
                StringBuffer nameBuf = new StringBuffer(name);
                if (name.length() > 0) {
                    nameBuf.append(" > ");
                }
                nameBuf.append(childName);
                nameQueue.addLast(nameBuf.toString());
            }
        }
        this.m_unassigned.set(state, unassigned);
        this.m_assigned.set(state, assigned);
        this.m_loaded.set(state, (Object)Boolean.TRUE);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class CategoryCollator
    implements Comparator {
        private Collator m_collator = Collator.getInstance();

        private CategoryCollator() {
        }

        public int compare(Object o1, Object o2) {
            CategoryKey m1 = (CategoryKey)o1;
            CategoryKey m2 = (CategoryKey)o2;
            return this.m_collator.compare(m1.getName(), m2.getName());
        }
    }

    public class CategoryKey {
        private BigDecimal m_id;
        private String m_name;

        public CategoryKey(BigDecimal id, String name) {
            this.m_id = id;
            this.m_name = name;
        }

        public String getName() {
            return this.m_name;
        }

        public BigDecimal getID() {
            return this.m_id;
        }

        public boolean equals(Object o) {
            try {
                CategoryKey key = (CategoryKey)o;
                return key.m_id.equals(this.m_id);
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        public int hashCode() {
            return this.m_id.hashCode();
        }
    }
}

