/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.ui.authoring;

import com.arsdigita.bebop.ColumnPanel;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Container;
import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.FormSection;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SaveCancelSection;
import com.arsdigita.bebop.event.FormInitListener;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.FormValidationListener;
import com.arsdigita.bebop.event.ParameterListener;
import com.arsdigita.bebop.form.TextField;
import com.arsdigita.bebop.parameters.NotNullValidationListener;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.bebop.parameters.TrimmedStringParameter;
import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.Folder;
import com.arsdigita.cms.ItemCollection;
import com.arsdigita.cms.ItemSelectionModel;
import com.arsdigita.cms.ui.authoring.NameValidationListener;
import com.arsdigita.cms.util.GlobalizationUtil;
import com.arsdigita.persistence.DataQuery;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.xml.Element;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.log4j.Logger;

public abstract class BasicItemForm
extends FormSection
implements FormInitListener,
FormProcessListener,
FormValidationListener {
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$cms$ui$authoring$BasicItemForm == null ? (class$com$arsdigita$cms$ui$authoring$BasicItemForm = BasicItemForm.class$("com.arsdigita.cms.ui.authoring.BasicItemForm")) : class$com$arsdigita$cms$ui$authoring$BasicItemForm));
    private final ItemSelectionModel m_itemModel;
    private SaveCancelSection m_saveCancelSection;
    private FormSection m_widgetSection;
    public static final String NAME = "name";
    public static final String TITLE = "title";
    public static final String LANGUAGE = "language";
    private Label m_script = new Label("<script language=\"javascript\">\n    var defaulting = false;\n\n    function urlize(title) {\n        var result = \"\";\n        for (var i = 0; i < title.length; i++) {\n            result = result + substitute(title.charAt(i));\n        }\n        return escape(result);\n    }\n\n    function substitute(c) {\n        switch (c) {\n            case \" \":\n                return \"-\";\n            case \"'\":\n            case \",\":\n            case \":\":\n            case \";\":\n            case \"?\":\n            case \"!\":\n                return \"\";\n            default:\n                return c.toLowerCase();\n        }\n    }\n</script>", false);
    static /* synthetic */ Class class$com$arsdigita$cms$ui$authoring$BasicItemForm;

    public BasicItemForm(String formName, ItemSelectionModel itemModel) {
        super((Container)new ColumnPanel(2));
        this.m_widgetSection = new FormSection((Container)new ColumnPanel(2, true));
        super.add((Component)this.m_widgetSection, 128);
        this.m_itemModel = itemModel;
        ColumnPanel panel = (ColumnPanel)this.getPanel();
        panel.setBorder(false);
        panel.setPadColor("#FFFFFF");
        panel.setColumnWidth(1, "20%");
        panel.setColumnWidth(2, "80%");
        panel.setWidth("100%");
        this.addWidgets();
        this.m_saveCancelSection = new SaveCancelSection();
        super.add((Component)this.m_saveCancelSection, 65);
        this.addInitListener(this);
        this.addProcessListener(this);
        this.addValidationListener(this);
    }

    public BasicItemForm(String formName, ColumnPanel columnPanel, ItemSelectionModel itemModel) {
        super((Container)columnPanel);
        this.m_widgetSection = new FormSection((Container)new ColumnPanel(columnPanel.getNumCols(), true));
        super.add((Component)this.m_widgetSection, 128);
        this.m_itemModel = itemModel;
    }

    public void addSaveCancelSection() {
        this.m_saveCancelSection = new SaveCancelSection();
        super.add((Component)this.m_saveCancelSection, 65);
    }

    protected void addWidgets() {
        this.add((Component)new Label(GlobalizationUtil.globalize("cms.ui.authoring.page_title")));
        TextField titleWidget = new TextField((ParameterModel)new TrimmedStringParameter(TITLE));
        titleWidget.addValidationListener((ParameterListener)new NotNullValidationListener());
        titleWidget.setOnFocus("if (this.form.name.value == '') {  defaulting = true; this.form.name.value = urlize(this.value); }");
        titleWidget.setOnKeyUp("if (defaulting) { this.form.name.value = urlize(this.value) }");
        this.add((Component)titleWidget);
        this.add((Component)new Label(GlobalizationUtil.globalize("cms.ui.authoring.name_url")));
        TextField nameWidget = new TextField((ParameterModel)new TrimmedStringParameter(NAME));
        nameWidget.addValidationListener((ParameterListener)new NameValidationListener());
        nameWidget.setOnFocus("defaulting = false");
        nameWidget.setOnBlur("if (this.value == '') { defaulting = true; this.value = urlize(this.form.title.value) }");
        this.add((Component)nameWidget);
    }

    public void generateXML(PageState ps, Element parent) {
        this.m_script.generateXML(ps, parent);
        super.generateXML(ps, parent);
    }

    public ItemSelectionModel getItemSelectionModel() {
        return this.m_itemModel;
    }

    public SaveCancelSection getSaveCancelSection() {
        return this.m_saveCancelSection;
    }

    public abstract void init(FormSectionEvent var1) throws FormProcessException;

    public abstract void process(FormSectionEvent var1) throws FormProcessException;

    public void validate(FormSectionEvent e) throws FormProcessException {
    }

    public void validateNameUniqueness(Folder parent, FormSectionEvent event) throws FormProcessException {
        FormData data = event.getFormData();
        String newName = (String)data.get((Object)NAME);
        if (newName != null) {
            String query = "com.arsdigita.cms.validateUniqueItemName";
            DataQuery dq = SessionManager.getSession().retrieveQuery("com.arsdigita.cms.validateUniqueItemName");
            dq.setParameter("parentId", (Object)parent.getID());
            dq.setParameter(NAME, (Object)newName.toUpperCase());
            if (dq.size() > 0L) {
                BigDecimal itemID = null;
                ContentItem item = null;
                if (this.getItemSelectionModel() != null) {
                    item = (ContentItem)this.getItemSelectionModel().getSelectedObject(event.getPageState());
                }
                if (item == null) {
                    throw new FormProcessException("An item with this name already exists");
                }
                Collection list = BasicItemForm.getAllVersionIDs(item);
                while (dq.next()) {
                    itemID = (BigDecimal)dq.get("itemID");
                    if (list.contains(itemID)) continue;
                    dq.close();
                    throw new FormProcessException("An item with this name already exists");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validateNameUniquenessWithinCategory(FormSectionEvent event, BigDecimal id) throws FormProcessException {
        if (id == null) {
            s_log.warn((Object)"Trying to validation the name uniqueness without  a valid item is invalid.  This method should only  be called in \"edit\" forms.  The passed in id  was null.");
            return;
        }
        FormData data = event.getFormData();
        String url = (String)data.get((Object)NAME);
        if (url == null) {
            return;
        }
        DataQuery query = SessionManager.getSession().retrieveQuery("com.arsdigita.categorization.getAllItemURLsForCategoryFromItem");
        query.setParameter("itemID", (Object)id);
        query.addEqualsFilter("lower(url)", (Object)url.toLowerCase());
        if (query.size() > 0L) {
            BigDecimal itemID = null;
            ContentItem item = (ContentItem)this.getItemSelectionModel().getSelectedObject(event.getPageState());
            Collection list = BasicItemForm.getAllVersionIDs(item);
            try {
                while (query.next()) {
                    itemID = (BigDecimal)query.get("itemID");
                    if (list.contains(itemID)) continue;
                    StringBuffer buffer = new StringBuffer("There are conflicts with this URL.  Specifically, there is at least one item in the same category as this item with the name (url) of ");
                    buffer.append(url);
                    throw new FormProcessException(buffer.toString());
                }
            }
            finally {
                query.close();
            }
        }
    }

    public static Collection getAllVersionIDs(ContentItem item) {
        ArrayList<BigDecimal> list = new ArrayList<BigDecimal>();
        list.add(item.getID());
        ContentItem live = item.getLiveVersion();
        if (live != null) {
            list.add(live.getID());
        }
        ItemCollection collection = item.getPendingVersions();
        while (collection.next()) {
            list.add(collection.getID());
        }
        return list;
    }

    public void add(Component pc) {
        this.m_widgetSection.add(pc);
    }

    public void add(Component pc, int constraints) {
        this.m_widgetSection.add(pc, constraints);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

