/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.ui.authoring;

import com.arsdigita.bebop.ColumnPanel;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Container;
import com.arsdigita.bebop.Form;
import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SaveCancelSection;
import com.arsdigita.bebop.event.FormInitListener;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.ParameterListener;
import com.arsdigita.bebop.form.TextField;
import com.arsdigita.bebop.parameters.NotNullValidationListener;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.bebop.parameters.StringParameter;
import com.arsdigita.cms.Article;
import com.arsdigita.cms.ImageAsset;
import com.arsdigita.cms.ItemSelectionModel;
import com.arsdigita.cms.util.GlobalizationUtil;
import com.arsdigita.domain.DomainObject;

public abstract class BasicImageForm
extends Form
implements FormInitListener,
FormProcessListener {
    public static final String versionId = "$Id: //cms/dev/src/com/arsdigita/cms/ui/authoring/BasicImageForm.java#7 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private ItemSelectionModel m_itemModel;
    private ItemSelectionModel m_assetModel;
    private SaveCancelSection m_saveCancelSection;
    public static final String CAPTION = "caption";

    public BasicImageForm(String formName, ItemSelectionModel itemModel, ItemSelectionModel assetModel) {
        super(formName, (Container)new ColumnPanel(2));
        this.m_itemModel = itemModel;
        this.m_assetModel = assetModel;
        ColumnPanel panel = (ColumnPanel)this.getPanel();
        panel.setBorder(false);
        panel.setPadColor("#FFFFFF");
        panel.setColumnWidth(1, "20%");
        panel.setColumnWidth(2, "80%");
        panel.setWidth("2%");
        this.addWidgets();
        this.m_saveCancelSection = new SaveCancelSection();
        this.add((Component)this.m_saveCancelSection, 65);
        this.addInitListener(this);
        this.addProcessListener(this);
    }

    protected void addWidgets() {
        this.add((Component)new Label(GlobalizationUtil.globalize("cms.ui.authoring.caption")));
        StringParameter captionParam = new StringParameter(CAPTION);
        captionParam.addParameterListener((ParameterListener)new NotNullValidationListener());
        TextField captionWidget = new TextField((ParameterModel)captionParam);
        this.add((Component)captionWidget);
    }

    public abstract void init(FormSectionEvent var1) throws FormProcessException;

    public abstract void process(FormSectionEvent var1) throws FormProcessException;

    public void initCaption(FormSectionEvent e) {
        String caption;
        FormData data = e.getFormData();
        PageState state = e.getPageState();
        Article item = this.getArticle(state);
        ImageAsset asset = this.getImageAsset(state);
        if (item != null && asset != null && (caption = item.getCaption(asset)) != null) {
            data.put((Object)CAPTION, (Object)caption);
        }
    }

    public void processCaption(FormSectionEvent e) {
        FormData data = e.getFormData();
        PageState state = e.getPageState();
        Article item = this.getArticle(state);
        ImageAsset asset = this.getImageAsset(state);
        if (item != null && asset != null) {
            item.addImage(asset, (String)data.get((Object)CAPTION));
        }
    }

    public ItemSelectionModel getItemSelectionModel() {
        return this.m_itemModel;
    }

    public ItemSelectionModel getAssetSelectionModel() {
        return this.m_assetModel;
    }

    public SaveCancelSection getSaveCancelSection() {
        return this.m_saveCancelSection;
    }

    public Article getArticle(PageState state) {
        return (Article)this.m_itemModel.getSelectedObject(state);
    }

    public ImageAsset getImageAsset(PageState state) {
        return (ImageAsset)this.m_assetModel.getSelectedObject(state);
    }

    public void setImageAsset(PageState state, ImageAsset asset) {
        this.m_assetModel.setSelectedObject(state, (DomainObject)asset);
    }
}

