/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.ui;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Image;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.Link;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.Table;
import com.arsdigita.bebop.event.TableActionAdapter;
import com.arsdigita.bebop.event.TableActionEvent;
import com.arsdigita.bebop.table.DefaultTableCellRenderer;
import com.arsdigita.bebop.table.TableCellRenderer;
import com.arsdigita.bebop.table.TableModel;
import com.arsdigita.bebop.table.TableModelBuilder;
import com.arsdigita.cms.ArticleImageAssociation;
import com.arsdigita.cms.ImageAsset;
import com.arsdigita.cms.SecurityManager;
import com.arsdigita.cms.dispatcher.Utilities;
import com.arsdigita.cms.ui.ImageBrowserModel;
import com.arsdigita.cms.ui.ImageBrowserModelBuilder;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.mimetypes.MimeType;
import com.arsdigita.mimetypes.image.ImageSizer;
import com.arsdigita.persistence.OID;
import com.arsdigita.util.LockableImpl;
import com.arsdigita.web.URL;
import java.awt.Dimension;
import java.math.BigDecimal;
import org.apache.log4j.Logger;

public class ImageBrowser
extends Table {
    public static final String versionId = "$Id: //cms/dev/src/com/arsdigita/cms/ui/ImageBrowser.java#15 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private ImageBrowserModelBuilder m_builder;
    private static final String[] HEADERS = new String[]{"Thumbnail", "Name", "Size", "Type", "Action", ""};
    private static final int THUMB = 0;
    private static final int NAME = 1;
    private static final int SIZE = 2;
    private static final int TYPE = 3;
    private static final int LINK = 4;
    private static final int DELETE = 5;
    private static final int NUM_COLUMNS = 6;
    private int m_thumbSize;
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$cms$ui$ImageBrowser == null ? (class$com$arsdigita$cms$ui$ImageBrowser = ImageBrowser.class$("com.arsdigita.cms.ui.ImageBrowser")) : class$com$arsdigita$cms$ui$ImageBrowser));
    static /* synthetic */ Class class$com$arsdigita$cms$ui$ImageBrowser;

    public ImageBrowser(ImageBrowserModelBuilder b) {
        super((TableModelBuilder)new BuilderAdapter(b), (Object[])HEADERS);
        this.setThumbnailSize(50);
        this.m_builder = b;
        this.getHeader().setDefaultRenderer((TableCellRenderer)new DefaultTableCellRenderer(false));
        this.getColumn(0).setCellRenderer((TableCellRenderer)new ThumbnailCellRenderer());
        this.getColumn(1).setCellRenderer((TableCellRenderer)new DefaultTableCellRenderer(false));
        this.getColumn(2).setCellRenderer((TableCellRenderer)new DefaultTableCellRenderer(false));
        this.getColumn(3).setCellRenderer((TableCellRenderer)new DefaultTableCellRenderer(false));
        this.getColumn(4).setCellRenderer((TableCellRenderer)new DefaultTableCellRenderer(true));
        this.getColumn(5).setCellRenderer((TableCellRenderer)new DeleteCellRenderer());
        this.setCellPadding("4");
        this.setBorder("1");
        this.setClassAttr("imageBrowser");
    }

    public int getThumbnailSize() {
        return this.m_thumbSize;
    }

    public void setThumbnailSize(int size) {
        this.m_thumbSize = size;
    }

    public ImageBrowserModelBuilder getImageBrowserModelBuilder() {
        return this.m_builder;
    }

    public ImageBrowserModel getImageBrowserModel(PageState state) {
        return ((ImageModelAdapter)this.getTableModel(state)).getModel();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class ImageModelAdapter
    implements TableModel {
        private ImageBrowserModel m_model;

        public ImageModelAdapter(ImageBrowserModel m) {
            this.m_model = m;
        }

        public int getColumnCount() {
            return 6;
        }

        public boolean nextRow() {
            return this.m_model.nextRow();
        }

        public Object getElementAt(int columnIndex) {
            ImageAsset a = this.m_model.getImageAsset();
            switch (columnIndex) {
                case 0: {
                    return a;
                }
                case 1: {
                    return a.getName();
                }
                case 2: {
                    StringBuffer buf = new StringBuffer();
                    BigDecimal v = a.getWidth();
                    if (v == null) {
                        buf.append("???");
                    } else {
                        buf.append(v.toString());
                    }
                    buf.append(" x ");
                    v = a.getHeight();
                    if (v == null) {
                        buf.append("???");
                    } else {
                        buf.append(v.toString());
                    }
                    return buf.toString();
                }
                case 3: {
                    MimeType m = a.getMimeType();
                    if (m == null) {
                        return "???";
                    }
                    return m.getMimeType();
                }
                case 4: {
                    return "select";
                }
                case 5: {
                    return "delete";
                }
            }
            return null;
        }

        public Object getKeyAt(int columnIndex) {
            return this.m_model.getImageAsset().getID();
        }

        public ImageBrowserModel getModel() {
            return this.m_model;
        }
    }

    private static class BuilderAdapter
    extends LockableImpl
    implements TableModelBuilder {
        private ImageBrowserModelBuilder m_builder;

        public BuilderAdapter(ImageBrowserModelBuilder b) {
            this.m_builder = b;
        }

        public TableModel makeModel(Table t, PageState s) {
            return new ImageModelAdapter(this.m_builder.makeModel((ImageBrowser)t, s));
        }

        public void lock() {
            this.m_builder.lock();
            super.lock();
        }
    }

    private class DeleteCellRenderer
    extends DefaultTableCellRenderer {
        public DeleteCellRenderer() {
            super(true);
        }

        public Component getComponent(Table table, PageState state, Object value, boolean isSelected, Object key, int row, int column) {
            boolean canDelete = false;
            SecurityManager sm = Utilities.getSecurityManager(state);
            if (sm.canAccess(state.getRequest(), "delete_images")) {
                try {
                    ImageAsset asset = (ImageAsset)DomainObjectFactory.newInstance((OID)new OID("com.arsdigita.cms.ImageAsset", (Object)((BigDecimal)key)));
                    if (!ArticleImageAssociation.imageHasAssociation(asset)) {
                        canDelete = true;
                    }
                }
                catch (DataObjectNotFoundException e) {
                    // empty catch block
                }
            }
            if (canDelete) {
                return super.getComponent(table, state, value, isSelected, key, row, column);
            }
            return new Label("");
        }
    }

    private class ThumbnailCellRenderer
    implements TableCellRenderer {
        private ThumbnailCellRenderer() {
        }

        public Component getComponent(Table table, PageState state, Object value, boolean isSelected, Object key, int row, int column) {
            int h;
            int w;
            ImageAsset a = (ImageAsset)value;
            String url = Utilities.getImageURL(a);
            Image img = new Image(URL.getDispatcherPath() + url);
            img.setBorder("0");
            img.setAlt(a.getName());
            BigDecimal width = a.getWidth();
            BigDecimal height = a.getHeight();
            if (width == null || height == null) {
                w = ImageBrowser.this.m_thumbSize;
                h = ImageBrowser.this.m_thumbSize;
            } else {
                Dimension d = ImageSizer.getScaledSize((int)width.intValue(), (int)height.intValue(), (int)ImageBrowser.this.m_thumbSize, (int)ImageBrowser.this.m_thumbSize);
                w = (int)d.getWidth();
                h = (int)d.getHeight();
            }
            img.setWidth(Integer.toString(w));
            img.setHeight(Integer.toString(h));
            return new Link((Component)img, url);
        }
    }

    public static abstract class LinkActionListener
    extends TableActionAdapter {
        public void cellSelected(TableActionEvent e) {
            int c = e.getColumn();
            if (c == 4) {
                this.linkClicked(e.getPageState(), new BigDecimal((String)e.getRowKey()));
            } else if (c == 5) {
                this.deleteClicked(e.getPageState(), new BigDecimal((String)e.getRowKey()));
            }
        }

        public abstract void linkClicked(PageState var1, BigDecimal var2);

        public abstract void deleteClicked(PageState var1, BigDecimal var2);
    }
}

