/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.search;

import com.arsdigita.categorization.Category;
import com.arsdigita.cms.ContentType;
import com.arsdigita.cms.search.ContentTypeFilterSpecification;
import com.arsdigita.cms.search.VersionFilterSpecification;
import com.arsdigita.kernel.PartyCollection;
import com.arsdigita.persistence.DataQuery;
import com.arsdigita.persistence.Filter;
import com.arsdigita.search.FilterSpecification;
import com.arsdigita.search.FilterType;
import com.arsdigita.search.filters.CategoryFilterSpecification;
import com.arsdigita.search.filters.DateRangeFilterSpecification;
import com.arsdigita.search.filters.PartyFilterSpecification;
import com.arsdigita.search.intermedia.BaseQueryEngine;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

public class IntermediaQueryEngine
extends BaseQueryEngine {
    public IntermediaQueryEngine() {
        this.addColumn("i.version", "version");
        this.addColumn("p.launch_date", "launch_date");
        this.addColumn("audited.last_modified", "last_modified");
        this.addColumn("audited.modifying_user", "modifying_user");
        this.addColumn("audited.creation_date", "creation_date");
        this.addColumn("audited.creation_user", "creation_user");
        this.addTable("cms_items", "i");
        this.addTable("cms_pages", "p");
        this.addTable("acs_auditing", "audited");
        this.addCondition("c.object_id = i.item_id");
        this.addCondition("c.object_id = p.item_id");
        this.addCondition("c.object_id = audited.object_id");
    }

    protected void addFilter(DataQuery query, FilterSpecification filter) {
        super.addFilter(query, filter);
        FilterType type = filter.getType();
        if ("contentType".equals(type.getKey())) {
            this.addContentTypeFilter(query, (ContentTypeFilterSpecification)filter);
        } else if ("version".equals(type.getKey())) {
            this.addVersionFilter(query, (VersionFilterSpecification)filter);
        } else if ("launchDate".equals(type.getKey())) {
            this.addLaunchDateFilter(query, (DateRangeFilterSpecification)filter);
        } else if ("lastModifiedDate".equals(type.getKey())) {
            this.addLastModifiedDateFilter(query, (DateRangeFilterSpecification)filter);
        } else if ("creationDate".equals(type.getKey())) {
            this.addCreationDateFilter(query, (DateRangeFilterSpecification)filter);
        } else if ("lastModifiedUser".equals(type.getKey())) {
            this.addPartyFilter(query, (PartyFilterSpecification)filter, "modifying_user");
        } else if ("creationUser".equals(type.getKey())) {
            this.addPartyFilter(query, (PartyFilterSpecification)filter, "creation_user");
        }
    }

    protected void addVersionFilter(DataQuery query, VersionFilterSpecification filter) {
        Filter f = query.addFilter("version = :version");
        f.set("version", (Object)filter.getVersion());
    }

    protected void addLaunchDateFilter(DataQuery query, DateRangeFilterSpecification filter) {
        this.addDateRangeFilter(query, filter, "launch_date");
    }

    protected void addLastModifiedDateFilter(DataQuery query, DateRangeFilterSpecification filter) {
        this.addDateRangeFilter(query, filter, "last_modified");
    }

    protected void addCreationDateFilter(DataQuery query, DateRangeFilterSpecification filter) {
        this.addDateRangeFilter(query, filter, "creation_date");
    }

    private void addDateRangeFilter(DataQuery query, DateRangeFilterSpecification filter, String columnName) {
        Filter f;
        Date start = filter.getStartDate();
        Date end = filter.getEndDate();
        SimpleDateFormat format = new SimpleDateFormat("MM/dd/yyyy");
        if (start != null) {
            f = query.addFilter(columnName + " >= :" + columnName + "StartDate");
            Calendar startCal = GregorianCalendar.getInstance();
            startCal.setTime(start);
            startCal.set(12, 0);
            startCal.set(11, 0);
            startCal.set(13, 0);
            f.set(columnName + "StartDate", (Object)startCal.getTime());
        }
        if (end != null) {
            f = query.addFilter(columnName + " < :" + columnName + "EndDate");
            Calendar endCal = GregorianCalendar.getInstance();
            endCal.setTime(end);
            endCal.set(12, 0);
            endCal.set(11, 0);
            endCal.set(13, 0);
            f.set(columnName + "EndDate", (Object)endCal.getTime());
        }
    }

    protected void addPartyFilter(DataQuery query, PartyFilterSpecification filter, String columnName) {
        PartyCollection parties = filter.getParties();
        if (parties == null) {
            return;
        }
        ArrayList<BigDecimal> partyIDs = new ArrayList<BigDecimal>();
        while (parties.next()) {
            partyIDs.add(parties.getID());
        }
        if (partyIDs.size() == 0) {
            query.addFilter("1=2");
        } else {
            Filter f = query.addFilter(columnName + " in :" + columnName + "parties");
            f.set(columnName + "parties", partyIDs);
        }
    }

    protected void addContentTypeFilter(DataQuery query, ContentTypeFilterSpecification filter) {
        ArrayList<String> l = new ArrayList<String>();
        ContentType[] types = filter.getTypes();
        if (types == null || types.length == 0) {
            return;
        }
        for (int i = 0; i < types.length; ++i) {
            ContentType type = types[i];
            l.add(type.getAssociatedObjectType());
        }
        Filter f = query.addFilter("object_type in :types");
        f.set("types", l);
    }

    protected void addCategoryFilter(DataQuery query, CategoryFilterSpecification filter) {
        Category[] categories = filter.getCategories();
        if (categories != null && categories.length > 0) {
            ArrayList<BigDecimal> ids = new ArrayList<BigDecimal>();
            for (int i = 0; i < categories.length; ++i) {
                ids.add(categories[i].getID());
            }
            Filter f = query.addInSubqueryFilter("object_id", "id", "com.arsdigita.cms.searchCategoryItems");
            f.set("ids", ids);
        }
    }
}

