/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.search;

import com.arsdigita.cms.FileAsset;
import com.arsdigita.cms.TextAsset;
import com.arsdigita.cms.search.ContentPageRawContentProvider;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.domain.DomainObjectTraversal;
import com.arsdigita.domain.DomainServiceInterfaceExposer;
import com.arsdigita.persistence.DataAssociation;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.metadata.ObjectType;
import com.arsdigita.persistence.metadata.Property;
import com.arsdigita.util.StringUtils;
import java.util.ArrayList;
import java.util.List;

public class ContentPageAssetExtractor
extends DomainObjectTraversal {
    private List m_content = new ArrayList();
    public static final String TEXT_ASSET_DATA_OBJ = "com.arsdigita.cms.TextAsset";
    public static final String FILE_ASSET_DATA_OBJ = "com.arsdigita.cms.FileAsset";

    public List getContent() {
        return this.m_content;
    }

    protected void beginObject(DomainObject obj, String path) {
    }

    protected void endObject(DomainObject obj, String path) {
    }

    protected void revisitObject(DomainObject obj, String path) {
    }

    protected void handleAttribute(DomainObject obj, String path, Property property) {
        Object value = DomainServiceInterfaceExposer.get((DomainObject)obj, (String)property.getName());
        if (value != null && property.isRole() && value instanceof DataObject) {
            ObjectType assetType = ((DataObject)value).getOID().getObjectType();
            String assetTypeName = assetType.getQualifiedName();
            if (assetTypeName.equals(TEXT_ASSET_DATA_OBJ)) {
                TextAsset ta = new TextAsset((DataObject)value);
                String text = ta.getText();
                if (text != null) {
                    text = StringUtils.htmlToText((String)text);
                    this.m_content.add(new ContentPageRawContentProvider("text", text.getBytes()));
                }
            } else if (assetTypeName.equals(FILE_ASSET_DATA_OBJ)) {
                FileAsset fa = new FileAsset((DataObject)value);
                this.m_content.add(new ContentPageRawContentProvider("file", fa.getContent()));
            }
        }
    }

    protected void beginRole(DomainObject obj, String path, Property property) {
    }

    protected void endRole(DomainObject obj, String path, Property property) {
    }

    protected void beginAssociation(DomainObject obj, String path, Property property) {
        DataAssociation association = (DataAssociation)DomainServiceInterfaceExposer.get((DomainObject)obj, (String)property.getName());
        if (association != null && association.getObjectType().isSubtypeOf(FILE_ASSET_DATA_OBJ)) {
            while (association.next()) {
                FileAsset fa = new FileAsset(association.getDataObject());
                this.m_content.add(new ContentPageRawContentProvider("file", fa.getContent()));
            }
        }
    }

    protected void endAssociation(DomainObject obj, String path, Property property) {
    }
}

