/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.installer;

import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.installer.ContentSectionSetup;
import com.arsdigita.cms.installer.Util;
import com.arsdigita.cms.util.GlobalizationUtil;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.initializer.Configuration;
import com.arsdigita.initializer.InitializationException;
import com.arsdigita.kernel.BaseInitializer;
import com.arsdigita.kernel.SiteNode;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.persistence.TransactionContext;
import com.arsdigita.util.Assert;
import com.arsdigita.web.Application;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Timer;
import org.apache.log4j.Logger;

public class SectionInitializer
extends BaseInitializer {
    public static final String versionId = "$Id: //cms/dev/src/com/arsdigita/cms/installer/SectionInitializer.java#42 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private static Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$cms$installer$SectionInitializer == null ? (class$com$arsdigita$cms$installer$SectionInitializer = SectionInitializer.class$("com.arsdigita.cms.installer.SectionInitializer")) : class$com$arsdigita$cms$installer$SectionInitializer));
    private static final String NAME = "name";
    private static final String TYPES = "types";
    private static final String ROLES = "roles";
    private static final String PUBLIC = "public";
    private static final String CATEGORIES = "categories";
    private static final String TASK_ALERTS = "taskAlerts";
    private static final String SEND_OVERDUE_ALERTS = "sendOverdueAlerts";
    private static final String TASK_DURATION = "taskDuration";
    private static final String OVERDUE_ALERT_INTERVAL = "alertInterval";
    private static final String MAX_ALERTS = "maxAlerts";
    private static final String ITEM_RESOLVER_CLASS = "itemResolverClass";
    private static final String TEMPLATE_RESOLVER_CLASS = "templateResolverClass";
    private Configuration m_conf = new Configuration();
    private static Timer s_unfinishedTimer;
    static /* synthetic */ Class class$com$arsdigita$cms$installer$SectionInitializer;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$util$List;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$com$arsdigita$cms$ContentSection;

    public SectionInitializer() throws InitializationException {
        this.m_conf.initParameter(NAME, "The name of the content section", class$java$lang$String == null ? (class$java$lang$String = SectionInitializer.class$("java.lang.String")) : class$java$lang$String);
        this.m_conf.initParameter(TYPES, "The content types to register", class$java$util$List == null ? (class$java$util$List = SectionInitializer.class$("java.util.List")) : class$java$util$List);
        this.m_conf.initParameter(ROLES, "The roles to create", class$java$util$List == null ? (class$java$util$List = SectionInitializer.class$("java.util.List")) : class$java$util$List);
        this.m_conf.initParameter(PUBLIC, "Whether to make published content available to non-registered users", class$java$lang$Boolean == null ? (class$java$lang$Boolean = SectionInitializer.class$("java.lang.Boolean")) : class$java$lang$Boolean);
        this.m_conf.initParameter(CATEGORIES, "XML file containing the category tree", class$java$util$List == null ? (class$java$util$List = SectionInitializer.class$("java.util.List")) : class$java$util$List, (Object)Collections.EMPTY_LIST);
        this.m_conf.initParameter(TASK_ALERTS, "A list of workflow tasks, and the events for which alerts are sent", class$java$util$List == null ? (class$java$util$List = SectionInitializer.class$("java.util.List")) : class$java$util$List);
        this.m_conf.initParameter(SEND_OVERDUE_ALERTS, "Send alerts when a task is overdue (has remained in the \"enabled\" state for a long time)", class$java$lang$Boolean == null ? (class$java$lang$Boolean = SectionInitializer.class$("java.lang.Boolean")) : class$java$lang$Boolean, (Object)Boolean.FALSE);
        this.m_conf.initParameter(TASK_DURATION, "How long a task can remain \"enabled\" before it is considered overdue (in hours)", class$java$lang$Integer == null ? (class$java$lang$Integer = SectionInitializer.class$("java.lang.Integer")) : class$java$lang$Integer);
        this.m_conf.initParameter(OVERDUE_ALERT_INTERVAL, "Time to wait between sending overdue notifications on the same task (in hours)", class$java$lang$Integer == null ? (class$java$lang$Integer = SectionInitializer.class$("java.lang.Integer")) : class$java$lang$Integer);
        this.m_conf.initParameter(MAX_ALERTS, "The maximum number of alerts to send that a single task is overdue", class$java$lang$Integer == null ? (class$java$lang$Integer = SectionInitializer.class$("java.lang.Integer")) : class$java$lang$Integer);
        this.m_conf.initParameter(ITEM_RESOLVER_CLASS, "The ItemResolver class to use for the section (defaults to MultilingualItemResolver)", class$java$lang$String == null ? (class$java$lang$String = SectionInitializer.class$("java.lang.String")) : class$java$lang$String);
        this.m_conf.initParameter(TEMPLATE_RESOLVER_CLASS, "The TemplateResolver class to use for the section (defaults to DefaultTemplateResolver)", class$java$lang$String == null ? (class$java$lang$String = SectionInitializer.class$("java.lang.String")) : class$java$lang$String);
    }

    public Configuration getConfiguration() {
        return this.m_conf;
    }

    protected void doStartup() {
        String name = (String)this.m_conf.getParameter(NAME);
        TransactionContext txn = SessionManager.getSession().getTransactionContext();
        txn.beginTxn();
        ContentSectionSetup.setupContentSectionAppType();
        Util.validateURLParameter(NAME, name);
        String sitemapEntry = "/" + name + "/";
        if (Application.isInstalled((String)"com.arsdigita.cms.ContentSection", (String)sitemapEntry)) {
            s_log.info((Object)("skipping " + name + " because it is already installed"));
        } else {
            s_log.info((Object)("Installing " + name + " at " + sitemapEntry));
            this.createSection(name);
        }
        ContentSection section = this.retrieveContentSection(name);
        Assert.exists((Object)((Object)section), (Class)(class$com$arsdigita$cms$ContentSection == null ? (class$com$arsdigita$cms$ContentSection = SectionInitializer.class$("com.arsdigita.cms.ContentSection")) : class$com$arsdigita$cms$ContentSection));
        ContentSectionSetup setup = new ContentSectionSetup(section);
        setup.loadAlertPrefs((List)this.m_conf.getParameter(TASK_ALERTS));
        s_unfinishedTimer = setup.startNotifierTask((Boolean)this.m_conf.getParameter(SEND_OVERDUE_ALERTS), (Integer)this.m_conf.getParameter(TASK_DURATION), (Integer)this.m_conf.getParameter(OVERDUE_ALERT_INTERVAL), (Integer)this.m_conf.getParameter(MAX_ALERTS));
        txn.commitTxn();
    }

    private ContentSection retrieveContentSection(String name) {
        BigDecimal rootNodeID = SiteNode.getRootSiteNode().getID();
        SiteNode node = null;
        try {
            node = SiteNode.getSiteNode((String)("/" + name));
        }
        catch (DataObjectNotFoundException ex) {
            throw new InitializationException((String)GlobalizationUtil.globalize("cms.installer.root_site_node_missing").localize(), (Throwable)ex);
        }
        ContentSection section = null;
        if (rootNodeID.equals(node.getID())) {
            section = this.createSection(name);
        } else {
            try {
                section = ContentSection.getSectionFromNode(node);
            }
            catch (DataObjectNotFoundException de) {
                throw new InitializationException((String)GlobalizationUtil.globalize("cms.installer.could_not_load_section", new Object[]{name}).localize(), (Throwable)de);
            }
        }
        return section;
    }

    protected void doShutdown() {
        if (s_unfinishedTimer != null) {
            s_unfinishedTimer.cancel();
            s_unfinishedTimer = null;
        }
    }

    private ContentSection createSection(String name) {
        s_log.info((Object)("Creating content section on /" + name));
        ContentSection section = ContentSection.create(name);
        ContentSectionSetup setup = new ContentSectionSetup(section);
        if (ContentSection.getConfig().getUseSectionCategories()) {
            Iterator files = ((List)this.m_conf.getParameter(CATEGORIES)).iterator();
            while (files.hasNext()) {
                setup.registerCategories((String)files.next());
            }
        }
        setup.registerRoles((List)this.m_conf.getParameter(ROLES));
        setup.registerViewers((Boolean)this.m_conf.getParameter(PUBLIC));
        setup.registerAlerts();
        setup.registerPublicationCycles();
        setup.registerWorkflowTemplates();
        setup.registerContentTypes((List)this.m_conf.getParameter(TYPES));
        setup.registerResolvers((String)this.m_conf.getParameter(ITEM_RESOLVER_CLASS), (String)this.m_conf.getParameter(TEMPLATE_RESOLVER_CLASS));
        section.save();
        return section;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

