/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.installer;

import com.arsdigita.categorization.Category;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.Folder;
import com.arsdigita.cms.dispatcher.Resource;
import com.arsdigita.cms.dispatcher.ResourceMapping;
import com.arsdigita.cms.dispatcher.ResourceType;
import com.arsdigita.cms.util.GlobalizationUtil;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.kernel.PackageEventListener;
import com.arsdigita.kernel.PackageInstance;
import com.arsdigita.kernel.PackageType;
import com.arsdigita.kernel.SiteNode;
import com.arsdigita.kernel.Stylesheet;
import com.arsdigita.kernel.permissions.PrivilegeDescriptor;
import com.arsdigita.persistence.DataQuery;
import com.arsdigita.persistence.SessionManager;

public class Installer
implements PackageEventListener {
    public static final String versionId = "$Id: //cms/dev/src/com/arsdigita/cms/installer/Installer.java#20 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    public static final String PACKAGE_KEY = "content-section";
    public static final String DISPATCHER_CLASS = "com.arsdigita.cms.dispatcher.ContentSectionDispatcher";
    public static final String LISTENER_CLASS = "com.arsdigita.cms.installer.Installer";
    public static final String STYLESHEET = "/packages/content-section/xsl/cms.xsl";

    protected static PackageType createPackageType() throws DataObjectNotFoundException {
        PackageType type = PackageType.create((String)PACKAGE_KEY, (String)"Content Management System", (String)"Content Management Systems", (String)"http://cms-java.arsdigita.com/");
        type.setDispatcherClass(DISPATCHER_CLASS);
        type.addListener(LISTENER_CLASS);
        Stylesheet ss = Stylesheet.createStylesheet((String)STYLESHEET);
        ss.save();
        type.addStylesheet(ss);
        type.save();
        Installer.createPrivileges();
        return type;
    }

    protected static PackageInstance createPackageInstance(String name) throws DataObjectNotFoundException {
        PackageType type = PackageType.findByKey((String)PACKAGE_KEY);
        PackageInstance instance = type.createInstance(name);
        instance.save();
        return instance;
    }

    protected static SiteNode mountPackageInstance(PackageInstance instance, String location) {
        SiteNode node = SiteNode.createSiteNode((String)location, (SiteNode)SiteNode.getRootSiteNode());
        node.mountPackage(instance);
        node.save();
        return node;
    }

    protected static void createDefaultResources(ContentSection section) {
        ResourceType rt = ResourceType.findResourceType("xml");
        Resource r = rt.createInstance("com.arsdigita.cms.ui.ContentSectionPage");
        r.save();
        ResourceMapping rm = r.createInstance(section, "admin");
        rm.save();
        rm = r.createInstance(section, "admin/index");
        rm.save();
        r = rt.createInstance("com.arsdigita.cms.ui.ContentItemPage");
        r.save();
        rm = r.createInstance(section, "admin/item");
        rm.save();
    }

    private static void createPrivileges() {
        String CMS_PRIVILEGES = "com.arsdigita.cms.getPrivileges";
        String PRIVILEGE = "privilege";
        DataQuery dq = SessionManager.getSession().retrieveQuery("com.arsdigita.cms.getPrivileges");
        while (dq.next()) {
            String privilege = (String)dq.get("privilege");
            if (PrivilegeDescriptor.get((String)privilege) != null) continue;
            PrivilegeDescriptor.createPrivilege((String)privilege);
        }
        dq.close();
    }

    protected static Folder createRootFolder(String name) {
        Folder root = new Folder();
        root.setName("/");
        root.setLabel((String)GlobalizationUtil.globalize("cms.installer.root_folder").localize());
        root.save();
        return root;
    }

    protected static Category createRootCategory(String name) {
        Category root = new Category("/", "Root Category");
        root.save();
        return root;
    }

    public void onMount(SiteNode siteNode, PackageInstance pkg) {
    }

    public void onUnmount(SiteNode siteNode, PackageInstance pkg) {
    }

    public void onCreate(PackageInstance pkg) {
    }

    public void onDelete(PackageInstance pkg) {
    }
}

