/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.installer;

import com.arsdigita.categorization.Category;
import com.arsdigita.categorization.RootCategoryCollection;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.ContentType;
import com.arsdigita.cms.ContentTypeLifecycleDefinition;
import com.arsdigita.cms.ContentTypeWorkflowTemplate;
import com.arsdigita.cms.Template;
import com.arsdigita.cms.TemplateManagerFactory;
import com.arsdigita.cms.lifecycle.LifecycleDefinition;
import com.arsdigita.cms.lifecycle.PhaseDefinition;
import com.arsdigita.cms.util.GlobalizationUtil;
import com.arsdigita.cms.workflow.CMSTask;
import com.arsdigita.cms.workflow.UnfinishedTaskNotifier;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.domain.DomainObjectInstantiator;
import com.arsdigita.initializer.InitializationException;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.kernel.ACSObjectInstantiator;
import com.arsdigita.kernel.Party;
import com.arsdigita.kernel.PartyCollection;
import com.arsdigita.kernel.Role;
import com.arsdigita.kernel.permissions.PermissionService;
import com.arsdigita.kernel.permissions.PrivilegeDescriptor;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.util.Assert;
import com.arsdigita.util.UncheckedWrapperException;
import com.arsdigita.web.ApplicationSetup;
import com.arsdigita.workflow.simple.Task;
import com.arsdigita.workflow.simple.WorkflowTemplate;
import com.arsdigita.xml.XML;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Date;
import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public final class ContentSectionSetup {
    private static final String STYLESHEET = "/packages/content-section/xsl/cms.xsl";
    private static Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$cms$installer$ContentSectionSetup == null ? (class$com$arsdigita$cms$installer$ContentSectionSetup = ContentSectionSetup.class$("com.arsdigita.cms.installer.ContentSectionSetup")) : class$com$arsdigita$cms$installer$ContentSectionSetup));
    private HashMap m_tasks = new HashMap();
    private LifecycleDefinition m_lcd;
    private WorkflowTemplate m_wf;
    final ContentSection m_section;
    static /* synthetic */ Class class$com$arsdigita$cms$installer$ContentSectionSetup;
    static /* synthetic */ Class class$com$arsdigita$cms$ContentSection;

    public ContentSectionSetup(ContentSection section) {
        Assert.exists((Object)((Object)section), (Class)(class$com$arsdigita$cms$ContentSection == null ? (class$com$arsdigita$cms$ContentSection = ContentSectionSetup.class$("com.arsdigita.cms.ContentSection")) : class$com$arsdigita$cms$ContentSection));
        this.m_section = section;
    }

    public void run() {
    }

    public static void setupContentSectionAppType() {
        ApplicationSetup setup = new ApplicationSetup((org.apache.log4j.Category)s_log);
        setup.setApplicationObjectType("com.arsdigita.cms.ContentSection");
        setup.setKey("content-section");
        setup.setTitle("CMS Content Section");
        setup.setDescription("A CMS Content Section");
        setup.setPortalApplication(false);
        setup.setStylesheet(STYLESHEET);
        setup.setInstantiator((DomainObjectInstantiator)new ACSObjectInstantiator(){

            public DomainObject doNewInstance(DataObject dataObject) {
                return new ContentSection(dataObject);
            }
        });
        setup.run();
    }

    public void registerCategories(String filename) {
        if (filename == null) {
            s_log.info((Object)"not loading any categories");
            return;
        }
        s_log.info((Object)("loading categories from " + filename));
        XML.parseResource((String)filename, (DefaultHandler)new CategoryHandler(this.m_section));
    }

    public void registerRoles(List roles) {
        Iterator i = roles.iterator();
        while (i.hasNext()) {
            List role = (List)i.next();
            String name = (String)role.get(0);
            String desc = (String)role.get(1);
            List privileges = (List)role.get(2);
            String task = role.size() > 3 ? (String)role.get(3) : null;
            s_log.info((Object)("Creating role " + name));
            Role group = this.registerRole(name, desc, privileges);
            if (task == null) continue;
            this.m_tasks.put(task, group);
        }
    }

    Role registerRole(String name, String desc, List privileges) {
        Role role = this.m_section.getStaffGroup().createRole(name);
        role.setDescription(desc);
        role.save();
        Iterator i = privileges.iterator();
        while (i.hasNext()) {
            String priv = (String)i.next();
            s_log.info((Object)("Granting privilege cms_" + priv));
            role.grantPermission((ACSObject)this.m_section, PrivilegeDescriptor.get((String)("cms_" + priv)));
            if (!priv.equals("category_admin") && !priv.equals("categorize_items")) continue;
            RootCategoryCollection coll = Category.getRootCategories((ACSObject)this.m_section);
            while (coll.next()) {
                if (priv.equals("category_admin")) {
                    role.grantPermission((ACSObject)coll.getCategory(), PrivilegeDescriptor.ADMIN);
                    continue;
                }
                role.grantPermission((ACSObject)coll.getCategory(), Category.MAP_DESCRIPTOR);
            }
        }
        return role;
    }

    public void registerResolvers(String itemResolverClass, String templateResolverClass) {
        if (itemResolverClass != null && itemResolverClass.length() > 0) {
            this.m_section.setItemResolverClass(itemResolverClass);
            s_log.info((Object)("Registering " + itemResolverClass + " as the item resolver class"));
        } else {
            this.m_section.setItemResolverClass(ContentSection.getConfig().getDefaultItemResolverClass().getName());
            s_log.info((Object)("Registering " + itemResolverClass + " as the item resolver class"));
        }
        if (templateResolverClass != null && templateResolverClass.length() > 0) {
            this.m_section.setTemplateResolverClass(templateResolverClass);
            s_log.info((Object)("Registering " + templateResolverClass + " as the template resolver class"));
        } else {
            this.m_section.setTemplateResolverClass(ContentSection.getConfig().getDefaultTemplateResolverClass().getName());
            s_log.info((Object)("Registering " + templateResolverClass + " as the template resolver class"));
        }
        this.m_section.save();
    }

    public void registerWorkflowTemplates() throws InitializationException {
        WorkflowTemplate wf = new WorkflowTemplate();
        wf.setLabel((String)GlobalizationUtil.globalize("cms.installer.production_workflow").localize());
        wf.setDescription("A process that involves creating and approving content.");
        wf.save();
        CMSTask authoring = new CMSTask();
        authoring.setLabel((String)GlobalizationUtil.globalize("cms.installer.authoring").localize());
        authoring.setDescription("Create content.");
        authoring.save();
        Role author = (Role)this.m_tasks.get("Authoring");
        if (author != null) {
            authoring.assignGroup(author.getGroup());
        }
        authoring.setTaskType(CMSTask.AUTHOR);
        authoring.save();
        CMSTask approval = new CMSTask();
        approval.setLabel((String)GlobalizationUtil.globalize("cms.installer.approval").localize());
        approval.setDescription("Approve content.");
        approval.save();
        approval.addDependency((Task)authoring);
        approval.save();
        Role approver = (Role)this.m_tasks.get("Approval");
        if (approver != null) {
            approval.assignGroup(approver.getGroup());
        }
        approval.setTaskType(CMSTask.EDIT);
        approval.save();
        CMSTask deploy = new CMSTask();
        deploy.setLabel((String)GlobalizationUtil.globalize("cms.installer.deploy").localize());
        deploy.setDescription("Deploy content.");
        deploy.save();
        deploy.addDependency((Task)approval);
        deploy.save();
        Role publisher = (Role)this.m_tasks.get("Publishing");
        if (publisher != null) {
            deploy.assignGroup(publisher.getGroup());
        }
        deploy.setTaskType(CMSTask.DEPLOY);
        deploy.save();
        wf.addTask((Task)authoring);
        wf.addTask((Task)approval);
        wf.addTask((Task)deploy);
        wf.save();
        this.m_section.addWorkflowTemplate(wf);
        this.m_section.save();
        this.m_wf = wf;
    }

    public void registerViewers(Boolean pub) {
        Role viewers = this.m_section.getViewersGroup().createRole("Content Reader");
        viewers.setDescription("Can view published pages within this section");
        viewers.save();
        viewers.grantPermission((ACSObject)this.m_section, PrivilegeDescriptor.get((String)"cms_read_item"));
        String email = Boolean.TRUE.equals(pub) ? "public@nullhost" : "registered@nullhost";
        Party viewer = this.retrieveParty(email);
        if (viewer == null) {
            throw new InitializationException((String)GlobalizationUtil.globalize("cms.installer.cannot_find_group_for_email").localize() + email);
        }
        s_log.info((Object)("Adding " + email + " to viewers role"));
        viewers.getGroup().addMemberOrSubgroup(viewer);
        viewers.save();
    }

    Party retrieveParty(String email) {
        PartyCollection parties = Party.retrieveAllParties();
        parties.filter(email);
        if (parties.next()) {
            Party party = parties.getParty();
            parties.close();
            return party;
        }
        return null;
    }

    public void registerAlerts() {
        Role alert = this.m_section.getStaffGroup().createRole("Alert Recipient");
        alert.setDescription("Receive alerts regarding expiration of pubished content");
        alert.save();
    }

    public void registerContentTypes(List types) {
        Iterator i = types.iterator();
        while (i.hasNext()) {
            Object obj = i.next();
            if (obj instanceof String) {
                this.registerContentType((String)obj);
                continue;
            }
            List list = (List)obj;
            String name = (String)list.get(0);
            String file = (String)list.get(1);
            ContentType type = this.registerContentType(name);
            this.registerTemplate(type, file);
        }
    }

    ContentType registerContentType(String name) {
        ContentType type = null;
        try {
            type = ContentType.findByAssociatedObjectType(name);
        }
        catch (DataObjectNotFoundException ex) {
            throw new UncheckedWrapperException((String)GlobalizationUtil.globalize("cms.installer.cannot_find_content_type").localize() + name, (Throwable)ex);
        }
        s_log.info((Object)("Adding type " + name + " to " + this.m_section.getDisplayName()));
        this.m_section.addContentType(type);
        s_log.info((Object)("Setting the default lifecycle for " + name + " to " + this.m_lcd.getLabel()));
        ContentTypeLifecycleDefinition.updateLifecycleDefinition(this.m_section, type, this.m_lcd);
        this.m_lcd.save();
        s_log.info((Object)("Setting the default workflow template for " + name + " to " + this.m_wf.getLabel()));
        ContentTypeWorkflowTemplate.updateWorkflowTemplate(this.m_section, type, this.m_wf);
        this.m_wf.save();
        return type;
    }

    void registerTemplate(ContentType type, String filename) {
        int pos1 = filename.lastIndexOf("/");
        int pos2 = filename.lastIndexOf(".");
        if (pos2 == -1) {
            pos2 = filename.length();
        }
        String label = filename.substring(pos1 + 1, pos2);
        String typename = type.getClassName();
        int pos3 = typename.lastIndexOf(".");
        String name = typename.substring(pos3 + 1, typename.length()) + "-" + label;
        Template temp = new Template();
        temp.setContentSection(this.m_section);
        temp.setName(name);
        temp.setLabel(label);
        temp.setParent((ACSObject)this.m_section.getTemplatesFolder());
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        InputStream stream = loader.getResourceAsStream(filename.substring(1));
        if (stream == null) {
            throw new IllegalStateException((String)GlobalizationUtil.globalize("cms.installer.cannot_find_file").localize() + filename);
        }
        BufferedReader input = new BufferedReader(new InputStreamReader(stream));
        StringBuffer body = new StringBuffer();
        while (true) {
            String line;
            try {
                line = input.readLine();
            }
            catch (IOException ex) {
                throw new UncheckedWrapperException((String)GlobalizationUtil.globalize("cms.installer.cannot_read_line_of_data").localize(), (Throwable)ex);
            }
            if (line == null) break;
            body.append(line);
            body.append("\n");
        }
        temp.setText(body.toString());
        temp.save();
        TemplateManagerFactory.getInstance().addTemplate(this.m_section, type, temp, "public");
        temp.publish(this.m_lcd, new Date());
    }

    public void registerPublicationCycles() throws InitializationException {
        LifecycleDefinition lcd = new LifecycleDefinition();
        lcd.setLabel((String)GlobalizationUtil.globalize("cms.installer.simple_publication").localize());
        lcd.setDescription("A one-phase lifecycle for items.");
        lcd.save();
        PhaseDefinition pd = lcd.addPhaseDefinition("Live", "The first phase. It lasts forever.", new Integer(0), null, null);
        pd.save();
        lcd.save();
        this.m_lcd = lcd;
        this.m_section.addLifecycleDefinition(lcd);
        this.m_section.save();
    }

    public void loadAlertPrefs(List tasks) {
        Iterator taskIter = null;
        if (tasks != null) {
            taskIter = tasks.iterator();
        }
        if (taskIter != null) {
            while (taskIter.hasNext()) {
                List oneTask = (List)taskIter.next();
                String taskName = (String)oneTask.get(0);
                List operationList = (List)oneTask.get(1);
                Iterator operationIter = null;
                if (operationList != null) {
                    operationIter = operationList.iterator();
                }
                if (operationIter == null) continue;
                while (operationIter.hasNext()) {
                    String operation = (String)operationIter.next();
                    CMSTask.addAlert(this.m_section, taskName, operation);
                }
            }
        }
    }

    public Timer startNotifierTask(Boolean sendOverdue, Integer duration, Integer alertInterval, Integer max) {
        Timer unfinished = null;
        if (sendOverdue.booleanValue()) {
            if (duration == null || alertInterval == null || max == null) {
                s_log.info((Object)"Not sending overdue task alerts, required initialization parameters were not specified");
                return null;
            }
            unfinished = new Timer(true);
            UnfinishedTaskNotifier notifier = new UnfinishedTaskNotifier(this.m_section, duration, alertInterval, max);
            unfinished.schedule((TimerTask)notifier, 300000L, 3600000L);
            s_log.info((Object)("Sending overdue alerts for tasks greater than " + duration + " hours old"));
        } else {
            s_log.info((Object)"Not sending overdue task alerts");
        }
        return unfinished;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class CategoryHandler
    extends DefaultHandler {
        private Stack m_cats = new Stack();
        private ContentSection m_section;

        public CategoryHandler(ContentSection section) {
            this.m_section = section;
        }

        public void startElement(String uri, String local, String qName, Attributes attrs) {
            if ("categories".equals(qName)) {
                String name = attrs.getValue("name");
                if (name == null) {
                    name = "Root";
                }
                String description = attrs.getValue("description");
                String context = attrs.getValue("context");
                Category root = Category.getRootForObject((ACSObject)this.m_section, (String)context);
                if (root == null) {
                    root = new Category();
                }
                root.setName(name);
                root.setDescription(description);
                if (root.isNew()) {
                    Category.setRootForObject((ACSObject)this.m_section, (Category)root, (String)context);
                }
                this.m_cats.push(root);
                PermissionService.setContext((ACSObject)root, (ACSObject)this.m_section);
            } else if ("category".equals(qName)) {
                String name = attrs.getValue("name");
                String description = attrs.getValue("description");
                String url = attrs.getValue("url");
                if (description == null) {
                    description = name;
                }
                s_log.debug((Object)("creating category '" + name + "'"));
                Category cat = new Category(name, description, url);
                cat.save();
                Category parent = null;
                try {
                    parent = (Category)this.m_cats.peek();
                }
                catch (EmptyStackException ex) {
                    throw new UncheckedWrapperException("no root category", (Throwable)ex);
                }
                parent.addChild((ACSObject)cat);
                parent.save();
                cat.setDefaultParentCategory(parent);
                cat.save();
                this.m_cats.push(cat);
            }
        }

        public void endElement(String uri, String local, String qName) {
            if ("category".equals(qName)) {
                this.m_cats.pop();
            } else if ("categories".equals(qName)) {
                this.m_cats.pop();
            }
        }
    }
}

