/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.dispatcher;

import com.arsdigita.bebop.PageState;
import com.arsdigita.caching.CacheTable;
import com.arsdigita.categorization.Category;
import com.arsdigita.categorization.CategoryCollection;
import com.arsdigita.cms.CategoryItemsQuery;
import com.arsdigita.cms.CategoryTemplateCollection;
import com.arsdigita.cms.CategoryTemplateMapping;
import com.arsdigita.cms.ContentBundle;
import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.ContentType;
import com.arsdigita.cms.Template;
import com.arsdigita.cms.dispatcher.CategoryItemResolver;
import com.arsdigita.cms.dispatcher.DefaultTemplateResolver;
import com.arsdigita.cms.dispatcher.MultilingualItemResolver;
import com.arsdigita.cms.dispatcher.TemplateResolver;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.persistence.OID;
import com.arsdigita.util.Assert;
import com.arsdigita.web.Web;
import java.math.BigDecimal;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public class CategoryItemResolverImpl
extends MultilingualItemResolver
implements CategoryItemResolver,
TemplateResolver {
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$cms$dispatcher$CategoryItemResolverImpl == null ? (class$com$arsdigita$cms$dispatcher$CategoryItemResolverImpl = CategoryItemResolverImpl.class$("com.arsdigita.cms.dispatcher.CategoryItemResolverImpl")) : class$com$arsdigita$cms$dispatcher$CategoryItemResolverImpl));
    public static final String CATEGORIES_PREFIX = "categories";
    private TemplateResolver m_templateResolver = new CategoryTemplateResolver();
    private static CacheTable s_itemURLCache = new CacheTable("CategoryItemResolverImplItemURLCache");
    static /* synthetic */ Class class$com$arsdigita$cms$dispatcher$CategoryItemResolverImpl;

    public Category getCategory(HttpServletRequest request) {
        String url = request.getRequestURI();
        ItemURLInfo itemURLInfo = (ItemURLInfo)s_itemURLCache.get(url);
        if (itemURLInfo == null) {
            return null;
        }
        return itemURLInfo.category;
    }

    public Category[] getCategoryPath(HttpServletRequest request) {
        String url = request.getRequestURI();
        ItemURLInfo itemURLInfo = (ItemURLInfo)s_itemURLCache.get(url);
        if (itemURLInfo == null) {
            return null;
        }
        return itemURLInfo.categoryPath;
    }

    public boolean isIndexRequest(HttpServletRequest request) {
        String url = request.getRequestURI();
        ItemURLInfo itemURLInfo = (ItemURLInfo)s_itemURLCache.get(url);
        if (itemURLInfo == null) {
            return false;
        }
        return itemURLInfo.isIndex;
    }

    public ContentItem getItem(ContentSection section, String url, String context) {
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Resolving the item in content section " + (Object)((Object)section) + " at URL '" + url + "' for context " + context));
        }
        Assert.assertNotNull((Object)((Object)section), (String)"ContentSection section");
        Assert.assertNotNull((Object)url, (String)"String url");
        Assert.assertNotNull((Object)context, (String)"String context");
        url = this.stripTemplateFromURL(url);
        if ("draft".equals(context) || !url.startsWith("/categories")) {
            return super.getItem(section, url, context);
        }
        String categoryURL = url.substring("/categories".length());
        Category root = section.getRootCategory();
        Assert.assertNotNull((Object)root);
        String file = null;
        String path = "";
        if (!"".equals(categoryURL)) {
            int index = categoryURL.lastIndexOf("/");
            if (index < 0) {
                file = categoryURL;
            }
            if ((file = categoryURL.substring(index + 1)).endsWith(".jsp")) {
                file = file.substring(0, file.length() - 4);
            }
            path = categoryURL.substring(0, index);
        }
        s_log.debug((Object)("Path is " + path));
        s_log.debug((Object)("File is " + file));
        Category[] cats = null;
        cats = root.getChildrenByURL(path + "/" + file);
        if (cats == null) {
            cats = path == "" ? new Category[]{root} : root.getChildrenByURL(path);
        } else {
            file = null;
        }
        if (cats == null) {
            return null;
        }
        Assert.assertTrue((cats.length >= 1 ? 1 : 0) != 0);
        Category cat = cats[cats.length - 1];
        s_log.debug((Object)("Category is " + cat.getDisplayName()));
        String lang = null;
        boolean isIndex = false;
        ContentItem item = null;
        if (file != null) {
            s_log.debug((Object)("Look for item " + file));
            String[] nameAndLang = this.getNameAndLangFromURLFrag(file);
            String name = nameAndLang[0];
            lang = nameAndLang[1];
            CategoryItemsQuery items = CategoryItemsQuery.retrieve(cat, context);
            items.addEqualsFilter("name", name);
            try {
                if (items.next()) {
                    item = (ContentItem)DomainObjectFactory.newInstance((OID)new OID(items.getObjectType(), (Object)items.getItemID()));
                }
            }
            catch (DataObjectNotFoundException ex) {
                // empty catch block
            }
            items.close();
        } else {
            s_log.debug((Object)"Look for index page");
            isIndex = true;
            ACSObject index = cat.getIndexObject();
            if (index != null && index instanceof ContentItem) {
                item = (ContentItem)index;
                if (!item.getVersion().equals("live")) {
                    item = item.getLiveVersion();
                }
            } else {
                item = null;
            }
        }
        ContentItem returnItem = this.getItemFromLangAndBundle(lang, item);
        if (returnItem != null) {
            HttpServletRequest request = Web.getRequest();
            CategoryItemResolverImpl.itemURLCachePut(request.getRequestURI(), new ItemURLInfo(cat, cats, isIndex));
        }
        return returnItem;
    }

    private static synchronized void itemURLCachePut(String url, ItemURLInfo info) {
        s_itemURLCache.put(url, (Object)info);
    }

    public String generateItemURL(PageState state, BigDecimal itemId, String name, ContentSection section, String context, Category category) {
        return this.generateItemURL(state, itemId, name, section, context, null, category);
    }

    public String generateItemURL(PageState state, BigDecimal itemId, String name, ContentSection section, String context, String templateContext, Category category) {
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Generating an item URL for item id " + itemId + ", section " + (Object)((Object)section) + ", and context '" + context + "' with name '" + name + "' in category '" + category + "'"));
        }
        Assert.assertNotNull((Object)itemId, (String)"BigDecimal itemId");
        Assert.assertNotNull((Object)context, (String)"Sring context");
        Assert.assertNotNull((Object)((Object)section), (String)"ContentSection section");
        if ("draft".equals(context)) {
            return this.generateDraftURL(section, itemId);
        }
        if ("preview".equals(context)) {
            ContentItem item = (ContentItem)DomainObjectFactory.newInstance((OID)new OID("com.arsdigita.cms.ContentItem", (Object)itemId));
            return this.generatePreviewURL(section, item, templateContext, category);
        }
        if ("live".equals(context)) {
            ContentItem item = (ContentItem)DomainObjectFactory.newInstance((OID)new OID("com.arsdigita.cms.ContentItem", (Object)itemId));
            if (Assert.isAssertEnabled()) {
                Assert.assertNotNull((Object)item, (String)"item");
                Assert.assertTrue((boolean)"live".equals(item.getVersion()), (String)"Generating live URL; this item must be the live version");
            }
            return this.generateLiveURL(section, item, templateContext, category);
        }
        throw new IllegalArgumentException("Unknown context '" + context + "'");
    }

    public String generateItemURL(PageState state, ContentItem item, ContentSection section, String context, Category category) {
        return this.generateItemURL(state, item, section, context, (String)null, category);
    }

    public String generateItemURL(PageState state, ContentItem item, ContentSection section, String context, String templateContext, Category category) {
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Generating an item URL for item " + item + ", section " + (Object)((Object)section) + ", and context " + context + " in category " + category));
        }
        Assert.assertNotNull((Object)item, (String)"ContentItem item");
        Assert.assertNotNull((Object)context, (String)"String context");
        if (section == null) {
            section = item.getContentSection();
        }
        if ("draft".equals(context)) {
            if (Assert.isAssertEnabled()) {
                Assert.assertTrue((boolean)"draft".equals(item.getVersion()), (String)"Generating draft url: item must be draft version");
            }
            return this.generateDraftURL(section, item.getID());
        }
        if ("preview".equals(context)) {
            return this.generatePreviewURL(section, item, templateContext, category);
        }
        if ("live".equals(context)) {
            if (Assert.isAssertEnabled()) {
                Assert.assertTrue((boolean)"live".equals(item.getVersion()), (String)"Generating live url: item must be live version");
            }
            return this.generateLiveURL(section, item, templateContext, category);
        }
        throw new RuntimeException("Unknown context " + context);
    }

    public String generateItemURL(PageState state, BigDecimal itemId, String name, ContentSection section, String context) {
        return this.generateItemURL(state, itemId, name, section, context, (String)null);
    }

    public String generateItemURL(PageState state, BigDecimal itemId, String name, ContentSection section, String context, String templateContext) {
        return this.generateItemURL(state, itemId, name, section, context, templateContext, null);
    }

    public String generateItemURL(PageState state, ContentItem item, ContentSection section, String context) {
        return this.generateItemURL(state, item, section, context, (String)null);
    }

    public String generateItemURL(PageState state, ContentItem item, ContentSection section, String context, String templateContext) {
        return this.generateItemURL(state, item, section, context, templateContext, (Category)null);
    }

    protected String generateLiveURL(ContentSection section, ContentItem item, String templateContext, Category category) {
        Category urlCategory;
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Generating live URL for item " + item + " in " + "section " + (Object)((Object)section)));
        }
        if ((urlCategory = this.getURLCategory(item, category)) == null) {
            return super.generateLiveURL(section, item, templateContext);
        }
        StringBuffer url = new StringBuffer(400);
        url.append(section.getPath()).append("/");
        if (templateContext != null && templateContext.length() > 0) {
            url.append("tem_").append(templateContext);
            url.append("/");
        }
        url.append("categories/");
        ContentItem bundle = (ContentItem)item.getParent();
        if (bundle != null && bundle instanceof ContentBundle) {
            s_log.debug((Object)"Found a bundle; building its file name");
            String fname = urlCategory.getQualifiedURL("/", false) + "/" + bundle.getName();
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)("Appending the bundle's file name '" + fname + "'"));
            }
            url.append(fname);
        } else {
            s_log.debug((Object)"No bundle found; using the item's path directly");
            url.append(urlCategory.getQualifiedURL("/", false));
            url.append("/").append(item.getName());
        }
        String language = item.getLanguage();
        if (language == null) {
            s_log.debug((Object)"The item has no language; omitting the language encoding");
        } else {
            s_log.debug((Object)("Encoding the language of the item passed in, '" + language + "'"));
            url.append(".").append(language);
        }
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Generated live URL " + url.toString()));
        }
        return url.toString();
    }

    protected String generatePreviewURL(ContentSection section, ContentItem item, String templateContext, Category category) {
        Assert.assertNotNull((Object)((Object)section), (String)"ContentSection section");
        Assert.assertNotNull((Object)item, (String)"ContentItem item");
        Category urlCategory = this.getURLCategory(item, category);
        if (urlCategory == null) {
            return super.generatePreviewURL(section, item, templateContext);
        }
        StringBuffer url = new StringBuffer(400);
        url.append(section.getPath());
        url.append("/");
        url.append("preview");
        url.append("/");
        if (templateContext != null && templateContext.length() >= 0) {
            url.append("tem_").append(templateContext);
            url.append("/");
        }
        url.append(CATEGORIES_PREFIX).append("/");
        ContentItem bundle = (ContentItem)item.getParent();
        if (bundle != null && bundle instanceof ContentBundle) {
            s_log.debug((Object)"Found a bundle; using its path");
            url.append(urlCategory.getQualifiedURL("/", false));
            url.append("/").append(bundle.getName());
        } else {
            s_log.debug((Object)"No bundle found; using the item's path directly");
            url.append(urlCategory.getQualifiedURL("/", false));
            url.append("/").append(item.getName());
        }
        String language = item.getLanguage();
        if (language == null) {
            s_log.debug((Object)"The item has no language; omitting the language encoding");
        } else {
            s_log.debug((Object)("Encoding the language of the item passed in, '" + language + "'"));
            url.append(".").append(language);
        }
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Generated preview URL " + url.toString()));
        }
        return url.toString();
    }

    private Category getURLCategory(ContentItem item, Category urlCat) {
        CategoryCollection categories = item.getCategoryCollection();
        Category firstCat = null;
        Category filteredCat = null;
        while (filteredCat == null && categories.next() && (firstCat == null || urlCat != null)) {
            Category cat = categories.getCategory();
            if (firstCat == null) {
                firstCat = cat;
            }
            if (!cat.equals((Object)urlCat)) continue;
            filteredCat = cat;
        }
        categories.close();
        return filteredCat != null ? filteredCat : firstCat;
    }

    public String getTemplate(ContentSection section, ContentItem item, HttpServletRequest request) {
        s_log.debug((Object)"getTemplate called");
        return this.m_templateResolver.getTemplate(section, item, request);
    }

    public String getTemplateXSLPath(Template template) {
        return this.m_templateResolver.getTemplateXSLPath(template);
    }

    public String getTemplatePath(Template template) {
        return this.m_templateResolver.getTemplatePath(template);
    }

    public void setTemplateContext(String sTemplateContext, HttpServletRequest request) {
        if (sTemplateContext != null) {
            request.setAttribute("templateContext", (Object)sTemplateContext);
        }
    }

    public String getTemplateContext(HttpServletRequest request) {
        String context = (String)request.getAttribute("templateContext");
        if (context == null) {
            context = "public";
        }
        return context;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class ItemURLInfo {
        Category category;
        Category[] categoryPath;
        boolean isIndex;

        ItemURLInfo(Category category, Category[] categoryPath, boolean isIndex) {
            this.category = category;
            this.categoryPath = categoryPath;
            this.isIndex = isIndex;
        }

        private String encodeAsString() {
            StringBuffer sb = new StringBuffer();
            sb.append(this.category.getID()).append(" / ");
            for (int i = 0; i < this.categoryPath.length; ++i) {
                sb.append(this.categoryPath[i].getID()).append(" ");
            }
            sb.append(this.isIndex);
            return sb.toString();
        }

        public boolean equals(ItemURLInfo obj) {
            return this.encodeAsString().equals(obj.encodeAsString());
        }

        public int hashCode() {
            return this.encodeAsString().hashCode();
        }
    }

    protected class CategoryTemplateResolver
    extends DefaultTemplateResolver {
        protected CategoryTemplateResolver() {
        }

        protected String getItemTemplate(ContentSection section, ContentItem item, HttpServletRequest request) {
            String templatePath = super.getItemTemplate(section, item, request);
            if (templatePath == null) {
                if (s_log.isDebugEnabled()) {
                    s_log.debug((Object)"No item template, looking for category template");
                }
                Category[] path = CategoryItemResolverImpl.this.getCategoryPath(request);
                Template template = null;
                if (path != null) {
                    ContentType type = item.getContentType();
                    String context = super.getTemplateContext(request);
                    for (int i = path.length - 1; i >= 0; --i) {
                        s_log.debug((Object)("Check cat " + path[i].getURL()));
                        CategoryTemplateCollection templates = CategoryTemplateMapping.getTemplates(path[i], type, context);
                        if (!templates.next()) continue;
                        template = templates.getTemplate();
                        s_log.debug((Object)("Found template for cat " + template.getID()));
                        templates.close();
                        break;
                    }
                }
                templatePath = template == null ? null : this.getTemplateFilename(template, section, item, request);
            }
            return templatePath;
        }
    }
}

