/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms;

import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.ReusableImageAsset;
import com.arsdigita.cms.lifecycle.Lifecycle;
import com.arsdigita.cms.lifecycle.LifecycleDefinition;
import com.arsdigita.cms.lifecycle.Phase;
import com.arsdigita.cms.lifecycle.PhaseCollection;
import com.arsdigita.cms.lifecycle.Scheduler;
import com.arsdigita.cms.publishToFile.QueueManager;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.domain.DomainServiceInterfaceExposer;
import com.arsdigita.initializer.Configuration;
import com.arsdigita.initializer.InitializationException;
import com.arsdigita.kernel.BaseInitializer;
import com.arsdigita.persistence.CompoundFilter;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.Filter;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.Session;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.persistence.TransactionContext;
import com.arsdigita.runtime.Startup;
import com.redhat.persistence.engine.rdbms.RDBMSException;
import java.math.BigDecimal;
import org.apache.log4j.Logger;

public class RickshawPublishAPIUpgrade
extends BaseInitializer {
    private static Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$cms$RickshawPublishAPIUpgrade == null ? (class$com$arsdigita$cms$RickshawPublishAPIUpgrade = RickshawPublishAPIUpgrade.class$("com.arsdigita.cms.RickshawPublishAPIUpgrade")) : class$com$arsdigita$cms$RickshawPublishAPIUpgrade));
    private Configuration m_conf = new Configuration();
    private TransactionContext m_txn = null;
    private int m_txnCounter = 0;
    private int m_itemsPerTransaction;
    private static final String ITEMS_PER_TRANSACTION = "itemsPerTransaction";
    public static final String PACKAGE_NAME = "com.arsdigita.cms";
    public static final String UPGRADE_ITEM_NO_LIFECYCLE_SET_TYPE = "com.arsdigita.cms.UpgradeItemNoLifecycleSet";
    public static final String UPGRADE_ITEM_LIFECYCLE_MAP_TYPE = "com.arsdigita.cms.UpgradeItemLifecycleMap";
    public static final String UPGRADE_ITEM = "item";
    public static final String UPGRADE_LIFECYCLE = "lifecycle";
    public static final String UPGRADE_PROGRESS_TYPE = "com.arsdigita.cms.UpgradeProgress";
    public static final String UPGRADE_PROGRESS_ID = "id";
    public static final BigDecimal UPGRADE_PROGRESS_ID_VALUE = new BigDecimal(1.0);
    public static final String PENDING_UNPUBLISH_DONE = "pendingUnpublishDone";
    public static final String LIVE_UNPUBLISH_DONE = "liveUnpublishDone";
    public static final String CLEANUP_UNPUBLISH_DONE = "cleanupUnpublishDone";
    public static final String NON_LIFECYCLE_PUBLISH_DONE = "nonLifecyclePublishDone";
    public static final String LIFECYCLE_PUBLISH_DONE = "lifecyclePublishDone";
    public static final String REMOVE_ORPHANED_LIFECYCLES_DONE = "removeOrphanedLifecyclesDone";
    static /* synthetic */ Class class$com$arsdigita$cms$RickshawPublishAPIUpgrade;
    static /* synthetic */ Class class$java$lang$Integer;

    public RickshawPublishAPIUpgrade() throws InitializationException {
        this.m_conf.initParameter(ITEMS_PER_TRANSACTION, "Number of items to process per transaction. ", class$java$lang$Integer == null ? (class$java$lang$Integer = RickshawPublishAPIUpgrade.class$("java.lang.Integer")) : class$java$lang$Integer, (Object)new Integer(25));
    }

    public Configuration getConfiguration() {
        return this.m_conf;
    }

    protected void doStartup() {
        s_log.info((Object)"disabling PublishToFilesystem and Lifecycle during publishing API content upgrade...");
        QueueManager.stopWatchingQueue();
        Scheduler.stopTimer();
        s_log.info((Object)"Starting publishing API content upgrade");
        this.m_itemsPerTransaction = (Integer)this.m_conf.getParameter(ITEMS_PER_TRANSACTION);
        this.m_txn = SessionManager.getSession().getTransactionContext();
        this.m_txn.beginTxn();
        if (!this.isUnpublishPendingItemsCompleted()) {
            s_log.info((Object)"Unpublishing pending items");
            this.unpublishPendingItems();
        } else {
            s_log.info((Object)"Pending items already unpublished");
        }
        if (!this.isUnpublishLiveItemsCompleted()) {
            s_log.info((Object)"Unpublishing live items");
            this.unpublishLiveItems();
        } else {
            s_log.info((Object)"Live items already unpublished");
        }
        if (!this.isCleanupPublishedItemsCompleted()) {
            s_log.info((Object)"Cleanup of any remaining live/pending items");
            this.cleanupPublishedItems();
        } else {
            s_log.info((Object)"Cleanup of any remaining live/pending items already completed");
        }
        if (!this.isPublishNonLifecycleItemsCompleted()) {
            s_log.info((Object)"Publishing non-lifecycle items");
            this.publishNonLifecycleItems();
        } else {
            s_log.info((Object)"non-lifecycle items already published");
        }
        if (!this.isPublishLifecycleItemsCompleted()) {
            s_log.info((Object)"Publishing lifecycle items");
            this.publishLifecycleItems();
        } else {
            s_log.info((Object)"lifecycle items already published");
        }
        if (!this.isRemoveOrphanedLifecyclesCompleted()) {
            s_log.info((Object)"Removing orphaned lifecycles");
            this.removeOrphanedLifecycles();
        } else {
            s_log.info((Object)"orphaned lifecycles already removed");
        }
        this.m_txn.commitTxn();
        s_log.info((Object)"Finishing publishing API content upgrade");
    }

    protected void doShutdown() {
    }

    public static final void main(String[] args) {
        System.out.println("Starting publishing API content upgrade");
        new Startup().run();
        RickshawPublishAPIUpgrade upgrade = new RickshawPublishAPIUpgrade();
        upgrade.doStartup();
        System.out.println("Publishing API content upgrade complete");
    }

    private void unpublishPendingItems() {
        Session session = SessionManager.getSession();
        for (int pass = 0; pass < 2; ++pass) {
            DataCollection items = session.retrieve("com.arsdigita.cms.ContentItem");
            items.addEqualsFilter("version", (Object)"pending");
            items.addNotEqualsFilter("masterVersion", null);
            items.addNotEqualsFilter("objectType", (Object)"com.arsdigita.cms.Folder");
            items.addNotEqualsFilter("objectType", (Object)"com.arsdigita.cms.ContentBundle");
            CompoundFilter orFilter = items.getFilterFactory().or();
            orFilter.addFilter(items.getFilterFactory().equals("parent.objectType", (Object)"com.arsdigita.cms.Folder"));
            orFilter.addFilter(items.getFilterFactory().equals("parent.objectType", (Object)"com.arsdigita.cms.ContentBundle"));
            items.addFilter((Filter)orFilter);
            while (items.next()) {
                try {
                    DataObject dataObj = items.getDataObject();
                    if (dataObj.isDeleted()) continue;
                    ContentItem item = (ContentItem)DomainObjectFactory.newInstance((DataObject)dataObj);
                    Lifecycle lifecycle = item.getLifecycle();
                    OID mapOID = null;
                    if (item instanceof ReusableImageAsset || lifecycle == null) {
                        mapOID = new OID(UPGRADE_ITEM_NO_LIFECYCLE_SET_TYPE);
                    } else {
                        mapOID = new OID(UPGRADE_ITEM_LIFECYCLE_MAP_TYPE);
                        mapOID.set(UPGRADE_LIFECYCLE, (Object)DomainServiceInterfaceExposer.getDataObject((DomainObject)lifecycle));
                    }
                    ContentItem draft = item.getDraftVersion();
                    s_log.debug((Object)("Unpublishing pending item: draft ID=" + draft.getID() + ", pending ID=" + item.getID() + ", name=" + item.getName() + ", lifecycle ID=" + (lifecycle == null ? "" : lifecycle.getID().toString())));
                    mapOID.set(UPGRADE_ITEM, (Object)DomainServiceInterfaceExposer.getDataObject((DomainObject)draft));
                    DataObject mapObj = session.retrieve(mapOID);
                    if (mapObj == null) {
                        mapObj = session.create(mapOID);
                    }
                    draft.removePendingVersion(item);
                    this.maybeCommit();
                }
                catch (RDBMSException e) {
                    if (pass == 0) continue;
                    throw e;
                }
            }
        }
        this.recordUnpublishPendingItemsCompletion();
    }

    private void unpublishLiveItems() {
        Session session = SessionManager.getSession();
        DataCollection items = session.retrieve("com.arsdigita.cms.ContentItem");
        items.addEqualsFilter("version", (Object)"live");
        items.addNotEqualsFilter("masterVersion", null);
        items.addNotEqualsFilter("objectType", (Object)"com.arsdigita.cms.Folder");
        items.addNotEqualsFilter("objectType", (Object)"com.arsdigita.cms.ContentBundle");
        CompoundFilter orFilter = items.getFilterFactory().or();
        orFilter.addFilter(items.getFilterFactory().equals("parent.objectType", (Object)"com.arsdigita.cms.Folder"));
        orFilter.addFilter(items.getFilterFactory().equals("parent.objectType", (Object)"com.arsdigita.cms.ContentBundle"));
        items.addFilter((Filter)orFilter);
        while (items.next()) {
            DataObject dataObj = items.getDataObject();
            ContentItem item = (ContentItem)DomainObjectFactory.newInstance((DataObject)dataObj);
            Lifecycle lifecycle = item.getLifecycle();
            OID mapOID = null;
            if (item instanceof ReusableImageAsset || lifecycle == null) {
                mapOID = new OID(UPGRADE_ITEM_NO_LIFECYCLE_SET_TYPE);
            } else {
                mapOID = new OID(UPGRADE_ITEM_LIFECYCLE_MAP_TYPE);
                mapOID.set(UPGRADE_LIFECYCLE, (Object)DomainServiceInterfaceExposer.getDataObject((DomainObject)lifecycle));
            }
            ContentItem draft = item.getDraftVersion();
            s_log.debug((Object)("Unpublishing live item: draft ID=" + draft.getID() + ", live ID=" + item.getID() + ", name=" + item.getName() + ", lifecycle ID=" + (lifecycle == null ? "" : lifecycle.getID().toString())));
            mapOID.set(UPGRADE_ITEM, (Object)DomainServiceInterfaceExposer.getDataObject((DomainObject)draft));
            DataObject mapObj = session.retrieve(mapOID);
            if (mapObj == null) {
                mapObj = session.create(mapOID);
            }
            draft.unpublish();
            this.maybeCommit();
        }
        this.recordUnpublishLiveItemsCompletion();
    }

    private void cleanupPublishedItems() {
        ContentItem draft;
        ContentItem item;
        DataObject dataObj;
        Session session = SessionManager.getSession();
        DataCollection items = session.retrieve("com.arsdigita.cms.ContentItem");
        items.addEqualsFilter("version", (Object)"pending");
        items.addNotEqualsFilter("objectType", (Object)"com.arsdigita.cms.Folder");
        items.addNotEqualsFilter("objectType", (Object)"com.arsdigita.cms.ContentBundle");
        while (items.next()) {
            dataObj = items.getDataObject();
            item = (ContentItem)DomainObjectFactory.newInstance((DataObject)dataObj);
            draft = item.getDraftVersion();
            if (draft == null) {
                s_log.debug((Object)("Unpublishing pending item: pending ID=" + item.getID() + ", name=" + item.getName() + ": NOT to be republished"));
                item.delete();
            } else {
                s_log.debug((Object)("Unpublishing pending item: draft ID=" + draft.getID() + ", pending ID=" + item.getID() + ", name=" + item.getName() + ": NOT to be republished"));
                draft.removePendingVersion(item);
            }
            this.maybeCommit();
        }
        items = session.retrieve("com.arsdigita.cms.ContentItem");
        items.addEqualsFilter("version", (Object)"live");
        items.addNotEqualsFilter("objectType", (Object)"com.arsdigita.cms.Folder");
        items.addNotEqualsFilter("objectType", (Object)"com.arsdigita.cms.ContentBundle");
        while (items.next()) {
            dataObj = items.getDataObject();
            item = (ContentItem)DomainObjectFactory.newInstance((DataObject)dataObj);
            draft = item.getDraftVersion();
            if (draft == null) {
                s_log.debug((Object)("Unpublishing live item: live ID=" + item.getID() + ", name=" + item.getName() + ": NOT to be republished"));
                item.delete();
            } else {
                s_log.debug((Object)("Unpublishing live item: draft ID=" + draft.getID() + ", live ID=" + item.getID() + ", name=" + item.getName() + ": NOT to be republished"));
                draft.unpublish();
            }
            this.maybeCommit();
        }
        items = session.retrieve("com.arsdigita.cms.ContentBundle");
        items.addEqualsFilter("version", (Object)"pending");
        while (items.next()) {
            dataObj = items.getDataObject();
            item = (ContentItem)DomainObjectFactory.newInstance((DataObject)dataObj);
            draft = item.getDraftVersion();
            if (draft == null) {
                s_log.debug((Object)("Unpublishing pending bundle: pending ID=" + item.getID() + ", name=" + item.getName()));
                item.delete();
            } else {
                s_log.debug((Object)("Unpublishing pending bundle: draft ID=" + draft.getID() + ", pending ID=" + item.getID() + ", name=" + item.getName()));
                draft.removePendingVersion(item);
                draft.removePendingVersion(item);
            }
            this.maybeCommit();
        }
        items = session.retrieve("com.arsdigita.cms.ContentBundle");
        items.addEqualsFilter("version", (Object)"live");
        while (items.next()) {
            dataObj = items.getDataObject();
            item = (ContentItem)DomainObjectFactory.newInstance((DataObject)dataObj);
            draft = item.getDraftVersion();
            if (draft == null) {
                s_log.debug((Object)("Unpublishing live bundle: live ID=" + item.getID() + ", name=" + item.getName()));
                item.delete();
            } else {
                s_log.debug((Object)("Unpublishing live bundle: draft ID=" + draft.getID() + ", live ID=" + item.getID() + ", name=" + item.getName()));
                draft.unpublish();
            }
            this.maybeCommit();
        }
        items = session.retrieve("com.arsdigita.cms.Folder");
        items.addEqualsFilter("version", (Object)"live");
        while (items.next()) {
            dataObj = items.getDataObject();
            item = (ContentItem)DomainObjectFactory.newInstance((DataObject)dataObj);
            draft = item.getDraftVersion();
            if (draft == null) {
                s_log.debug((Object)("Unpublishing live folder: live ID=" + item.getID() + ", name=" + item.getName()));
                item.delete();
            } else {
                s_log.debug((Object)("Unpublishing live folder: draft ID=" + draft.getID() + ", live ID=" + item.getID() + ", name=" + item.getName()));
                draft.unpublish();
            }
            this.maybeCommit();
        }
        this.recordCleanupPublishedItemsCompletion();
    }

    private void publishNonLifecycleItems() {
        Session session = SessionManager.getSession();
        DataCollection coll = session.retrieve(UPGRADE_ITEM_NO_LIFECYCLE_SET_TYPE);
        while (coll.next()) {
            DataObject dataObj = (DataObject)coll.get(UPGRADE_ITEM);
            ContentItem item = (ContentItem)DomainObjectFactory.newInstance((DataObject)dataObj);
            ContentItem live = item.createLiveVersion();
            coll.getDataObject().delete();
            s_log.debug((Object)("Publishing item with no lifecycle: draft ID=" + item.getID() + ", published ID=" + live.getID() + ", name=" + item.getName()));
            this.maybeCommit();
        }
        this.recordPublishNonLifecycleItemsCompletion();
    }

    private void publishLifecycleItems() {
        Session session = SessionManager.getSession();
        DataCollection coll = session.retrieve(UPGRADE_ITEM_LIFECYCLE_MAP_TYPE);
        while (coll.next()) {
            DataObject dataObj = (DataObject)coll.get(UPGRADE_ITEM);
            ContentItem item = (ContentItem)DomainObjectFactory.newInstance((DataObject)dataObj);
            dataObj = (DataObject)coll.get(UPGRADE_LIFECYCLE);
            Lifecycle lifecycle = new Lifecycle(dataObj);
            LifecycleDefinition cycleDef = lifecycle.getLifecycleDefinition();
            ContentItem pending = item.publish(cycleDef, lifecycle.getStartDate());
            Lifecycle newLifecycle = pending.getLifecycle();
            s_log.debug((Object)("Publishing item: draft ID=" + item.getID() + ", published ID=" + pending.getID() + ", name=" + item.getName() + ", lifecycle ID=" + newLifecycle.getID()));
            newLifecycle.setEndDate(lifecycle.getEndDate());
            PhaseCollection oldPhases = lifecycle.getPhases();
            PhaseCollection newPhases = newLifecycle.getPhases();
            while (newPhases.next()) {
                if (!oldPhases.next()) continue;
                Phase newPhase = newPhases.getPhase();
                Phase oldPhase = oldPhases.getPhase();
                newPhase.setStartDate(oldPhase.getStartDate());
                newPhase.setEndDate(oldPhase.getEndDate());
            }
            newPhases.close();
            oldPhases.close();
            coll.getDataObject().delete();
            this.maybeCommit();
        }
        this.recordPublishLifecycleItemsCompletion();
    }

    private void removeOrphanedLifecycles() {
        DataCollection coll = SessionManager.getSession().retrieve("com.arsdigita.cms.Lifecycle");
        coll.addNotInSubqueryFilter(UPGRADE_PROGRESS_ID, "com.arsdigita.cms.getConnectedLifecycles");
        while (coll.next()) {
            DataObject dataObj = coll.getDataObject();
            Lifecycle lifecycle = new Lifecycle(dataObj);
            s_log.debug((Object)("Deleting orphaned lifecycle: ID=" + lifecycle.getID()));
            lifecycle.delete();
            this.maybeCommit();
        }
        this.recordRemoveOrphanedLifecyclesCompletion();
    }

    private void maybeCommit() {
        ++this.m_txnCounter;
        if (this.m_txnCounter == this.m_itemsPerTransaction) {
            s_log.debug((Object)"Publish API upgrade: transaction commit");
            this.m_txn.commitTxn();
            this.m_txn.beginTxn();
            this.m_txnCounter = 0;
        }
    }

    private void forceCommit() {
        s_log.debug((Object)"Publish API upgrade: transaction commit");
        this.m_txn.commitTxn();
        this.m_txn.beginTxn();
        this.m_txnCounter = 0;
    }

    private boolean isUnpublishPendingItemsCompleted() {
        return (Boolean)this.getUpgradeProgress().get(PENDING_UNPUBLISH_DONE);
    }

    private boolean isUnpublishLiveItemsCompleted() {
        return (Boolean)this.getUpgradeProgress().get(LIVE_UNPUBLISH_DONE);
    }

    private boolean isCleanupPublishedItemsCompleted() {
        return (Boolean)this.getUpgradeProgress().get(CLEANUP_UNPUBLISH_DONE);
    }

    private boolean isPublishNonLifecycleItemsCompleted() {
        return (Boolean)this.getUpgradeProgress().get(NON_LIFECYCLE_PUBLISH_DONE);
    }

    private boolean isPublishLifecycleItemsCompleted() {
        return (Boolean)this.getUpgradeProgress().get(LIFECYCLE_PUBLISH_DONE);
    }

    private boolean isRemoveOrphanedLifecyclesCompleted() {
        return (Boolean)this.getUpgradeProgress().get(REMOVE_ORPHANED_LIFECYCLES_DONE);
    }

    private void recordUnpublishPendingItemsCompletion() {
        this.getUpgradeProgress().set(PENDING_UNPUBLISH_DONE, (Object)Boolean.TRUE);
        this.forceCommit();
    }

    private void recordUnpublishLiveItemsCompletion() {
        this.getUpgradeProgress().set(LIVE_UNPUBLISH_DONE, (Object)Boolean.TRUE);
        this.forceCommit();
    }

    private void recordCleanupPublishedItemsCompletion() {
        this.getUpgradeProgress().set(CLEANUP_UNPUBLISH_DONE, (Object)Boolean.TRUE);
        this.forceCommit();
    }

    private void recordPublishNonLifecycleItemsCompletion() {
        this.getUpgradeProgress().set(NON_LIFECYCLE_PUBLISH_DONE, (Object)Boolean.TRUE);
        this.forceCommit();
    }

    private void recordPublishLifecycleItemsCompletion() {
        this.getUpgradeProgress().set(LIFECYCLE_PUBLISH_DONE, (Object)Boolean.TRUE);
        this.forceCommit();
    }

    private void recordRemoveOrphanedLifecyclesCompletion() {
        this.getUpgradeProgress().set(REMOVE_ORPHANED_LIFECYCLES_DONE, (Object)Boolean.TRUE);
        this.forceCommit();
    }

    private DataObject getUpgradeProgress() {
        Session session = SessionManager.getSession();
        DataCollection coll = session.retrieve(UPGRADE_PROGRESS_TYPE);
        DataObject progressObj = null;
        if (coll.next()) {
            progressObj = coll.getDataObject();
            coll.close();
        } else {
            OID oid = null;
            oid = new OID(UPGRADE_PROGRESS_TYPE);
            oid.set(UPGRADE_PROGRESS_ID, (Object)UPGRADE_PROGRESS_ID_VALUE);
            progressObj = session.create(oid);
            progressObj.set(PENDING_UNPUBLISH_DONE, (Object)Boolean.FALSE);
            progressObj.set(LIVE_UNPUBLISH_DONE, (Object)Boolean.FALSE);
            progressObj.set(CLEANUP_UNPUBLISH_DONE, (Object)Boolean.FALSE);
            progressObj.set(NON_LIFECYCLE_PUBLISH_DONE, (Object)Boolean.FALSE);
            progressObj.set(LIFECYCLE_PUBLISH_DONE, (Object)Boolean.FALSE);
            progressObj.set(REMOVE_ORPHANED_LIFECYCLES_DONE, (Object)Boolean.FALSE);
        }
        return progressObj;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

