/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms;

import com.arsdigita.auditing.BasicAuditTrail;
import com.arsdigita.cms.CMS;
import com.arsdigita.cms.CMSContext;
import com.arsdigita.cms.ContentBundle;
import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.CustomCopy;
import com.arsdigita.cms.ItemCopier;
import com.arsdigita.cms.SecurityManager;
import com.arsdigita.cms.UserHomeFolderMap;
import com.arsdigita.cms.lifecycle.Lifecycle;
import com.arsdigita.cms.lifecycle.LifecycleDefinition;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.domain.DomainCollection;
import com.arsdigita.domain.DomainCollectionIterator;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.kernel.User;
import com.arsdigita.kernel.permissions.PermissionService;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.DataQuery;
import com.arsdigita.persistence.DataQueryDataCollectionAdapter;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.PersistenceException;
import com.arsdigita.persistence.Session;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.persistence.metadata.Property;
import com.arsdigita.util.Assert;
import com.arsdigita.util.UncheckedWrapperException;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class Folder
extends ContentItem {
    public static final String versionId = "$Id: //cms/dev/src/com/arsdigita/cms/Folder.java#41 $$Author: dennis $$DateTime: 2004/04/07 16:07:11 $";
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$cms$Folder == null ? (class$com$arsdigita$cms$Folder = Folder.class$("com.arsdigita.cms.Folder")) : class$com$arsdigita$cms$Folder));
    public static final String BASE_DATA_OBJECT_TYPE = "com.arsdigita.cms.Folder";
    public static final String INDEX = "index";
    public static final String HOME_FOLDER = "homeFolder";
    public static final String HOME_SECTION = "homeSection";
    private static final String ITEMS_QUERY = "com.arsdigita.cms.ItemsInFolder";
    private static final String PRIMARY_INSTANCES_QUERY = "com.arsdigita.cms.PrimaryInstancesInFolder";
    private static final String ITEM_QUERY = "com.arsdigita.cms.ItemInFolder";
    private static final String FOLDER_QUERY = "com.arsdigita.cms.FolderInFolder";
    private static final String LABEL = "label";
    private static final String NAME = "name";
    private static final String ITEM = "item";
    private boolean m_wasNew;
    protected static final String ITEMS = "items";
    static /* synthetic */ Class class$com$arsdigita$cms$Folder;

    public Folder() {
        super(BASE_DATA_OBJECT_TYPE);
    }

    public Folder(OID oid) throws DataObjectNotFoundException {
        super(oid);
    }

    public Folder(BigDecimal id) throws DataObjectNotFoundException {
        this(new OID(BASE_DATA_OBJECT_TYPE, (Object)id));
    }

    public Folder(DataObject obj) {
        super(obj);
    }

    public Folder(String type) {
        super(type);
    }

    protected ContentItem makeCopy() {
        Folder newItem = (Folder)super.makeCopy();
        DomainCollectionIterator items = new DomainCollectionIterator((DomainCollection)this.getItems());
        newItem.copyItemsToFolder((Iterator)items);
        return newItem;
    }

    public void copyItemsToFolder(Iterator items) {
        while (items.hasNext()) {
            ContentItem item = (ContentItem)items.next();
            item.copy(this, true);
        }
    }

    public String getBaseDataObjectType() {
        return BASE_DATA_OBJECT_TYPE;
    }

    public void delete() throws IllegalStateException {
        s_log.debug((Object)"Deleting folder");
        if (!this.isEmpty()) {
            throw new IllegalStateException("Attempt to delete non-empty folder " + this.getOID() + "; " + "only empty folders can be deleted");
        }
        super.delete();
    }

    protected void beforeDelete() {
        DataCollection maps = SessionManager.getSession().retrieve("com.arsdigita.cms.UserHomeFolderMap");
        maps.addEqualsFilter("homeFolder.id", (Object)this.getID());
        while (maps.next()) {
            maps.getDataObject().delete();
        }
        super.beforeDelete();
    }

    protected void beforeSave() {
        this.m_wasNew = this.isNew();
        super.beforeSave();
    }

    protected void afterSave() {
        ContentItem workingVersion;
        ContentSection section;
        ACSObject parent;
        super.afterSave();
        if (this.m_wasNew && (parent = this.getParent()) == null && (section = this.getContentSection()) != null && (this.equals(section.getRootFolder()) || this.equals(section.getTemplatesFolder()))) {
            PermissionService.setContext((ACSObject)this, (ACSObject)section);
        }
        if (!this.equals(workingVersion = this.getWorkingVersion())) {
            PermissionService.setContext((ACSObject)this, (ACSObject)workingVersion);
        }
    }

    public ItemCollection getItems(boolean bSort) {
        DataQuery query = SessionManager.getSession().retrieveQuery(ITEMS_QUERY);
        query.setParameter("parent", (Object)this.getID());
        Assert.unequal((Object)"pending", (Object)this.getVersion());
        query.setParameter("version", (Object)this.getVersion());
        return new ItemCollection(query, bSort);
    }

    public ItemCollection getItems() {
        return this.getItems(true);
    }

    public ItemCollection getPrimaryInstances() {
        DataQuery query = SessionManager.getSession().retrieveQuery(PRIMARY_INSTANCES_QUERY);
        query.setParameter("parent", (Object)this.getID());
        Assert.unequal((Object)"pending", (Object)this.getVersion());
        query.setParameter("version", (Object)this.getVersion());
        return new ItemCollection(query);
    }

    public ContentItem getItem(String name, boolean isFolder) {
        DataQuery query = isFolder ? SessionManager.getSession().retrieveQuery(FOLDER_QUERY) : SessionManager.getSession().retrieveQuery(ITEM_QUERY);
        query.setParameter("parent", (Object)this.getID());
        query.setParameter("version", (Object)this.getVersion());
        query.setParameter(NAME, (Object)name);
        DataQueryDataCollectionAdapter items = new DataQueryDataCollectionAdapter(query, ITEM);
        if (items.next()) {
            DataObject dataObj = items.getDataObject();
            ContentItem result = (ContentItem)DomainObjectFactory.newInstance((DataObject)dataObj);
            if (items.next()) {
                s_log.warn((Object)("Item in folder has a duplicate name; one is " + result + " and one is " + (ContentItem)DomainObjectFactory.newInstance((DataObject)items.getDataObject())));
                throw new IllegalStateException();
            }
            return result;
        }
        return null;
    }

    public void addItem(ContentBundle item) {
        item.setParent((ACSObject)this);
        item.save();
    }

    public String getDisplayName() {
        String result = this.getLabel();
        if (result == null) {
            return super.getDisplayName();
        }
        return result;
    }

    public final String getLabel() {
        return (String)this.get(LABEL);
    }

    public final void setLabel(String value) {
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Setting label to " + value));
        }
        this.set(LABEL, value);
    }

    protected void setVersion(String version) {
        if ("pending".equals(version)) {
            version = "live";
        }
        super.setVersion(version);
    }

    public void unpublish() {
        if (s_log.isInfoEnabled()) {
            s_log.info((Object)("Unpublishing folder " + this));
        }
        super.unpublish();
    }

    public ContentItem publish(LifecycleDefinition cycleDef, Date startDate) {
        if (s_log.isInfoEnabled()) {
            s_log.info((Object)("Publishing folder " + this));
        }
        return super.publish(cycleDef, startDate);
    }

    public Lifecycle getLifecycle() {
        return null;
    }

    public void setLifecycle(Lifecycle cycle) {
    }

    public void removeLifecycle() {
    }

    protected void addPendingVersion(ContentItem version) {
        if (Assert.isEnabled()) {
            this.assertDraft();
        }
        version.setVersion("live");
        this.setLiveVersion(version);
    }

    public void removePendingVersion(ContentItem version) {
        Assert.unequal((Object)"pending", (Object)version.getVersion());
    }

    public ContentBundle getIndexItem() {
        if (this.getVersion().compareTo("live") == 0) {
            ContentBundle indexItem = ((Folder)this.getWorkingVersion()).getIndexItem();
            if (indexItem == null) {
                return null;
            }
            return (ContentBundle)indexItem.getLiveVersion();
        }
        DataObject index = (DataObject)this.get(INDEX);
        if (index == null) {
            return null;
        }
        try {
            return (ContentBundle)DomainObjectFactory.newInstance((DataObject)index);
        }
        catch (PersistenceException pe) {
            throw new UncheckedWrapperException((Throwable)pe);
        }
    }

    public final void setIndexItem(ContentBundle item) {
        this.setAssociation(INDEX, (DomainObject)item);
        this.addItem(item);
    }

    public final void removeIndexItem() {
        this.setAssociation(INDEX, null);
    }

    public boolean isEmpty() {
        Session session = SessionManager.getSession();
        DataQuery query = session.retrieveQuery("com.arsdigita.cms.folderNotEmpty");
        query.setParameter("id", (Object)this.getID());
        boolean result = !query.next();
        query.close();
        return result;
    }

    public boolean containsFolders() {
        Session session = SessionManager.getSession();
        DataQuery query = session.retrieveQuery("com.arsdigita.cms.folderHasNoSubFolders");
        query.setParameter("id", (Object)this.getID());
        boolean result = !query.next();
        query.close();
        return result;
    }

    public boolean copyProperty(CustomCopy srcItem, Property property, ItemCopier copier) {
        String attrName = property.getName();
        if (ITEMS.equals(attrName) || INDEX.equals(attrName)) {
            return true;
        }
        return super.copyProperty(srcItem, property, copier);
    }

    protected boolean canPublishToFS() {
        return false;
    }

    public boolean autoPublishIfAssociated() {
        return true;
    }

    public static void setUserHomeFolder(User user, Folder folder) {
        UserHomeFolderMap map = UserHomeFolderMap.findOrCreateUserHomeFolderMap(user, folder.getContentSection());
        map.setHomeFolder(folder);
        map.save();
    }

    public static Folder getUserHomeFolder(User user, ContentSection section) {
        CMSContext context;
        SecurityManager sm;
        Folder folder = null;
        UserHomeFolderMap map = UserHomeFolderMap.findUserHomeFolderMap(user, section);
        if (map != null && (folder = map.getHomeFolder()) != null && !(sm = (context = CMS.getContext()).hasSecurityManager() ? CMS.getContext().getSecurityManager() : new SecurityManager(section)).canAccess(user, "preview_pages", (ContentItem)folder)) {
            folder = null;
        }
        return folder;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class ItemCollection
    extends com.arsdigita.cms.ItemCollection {
        private static final String IS_FOLDER = "isFolder";
        private static final String ITEM = "item";
        private static final String HAS_LIVE_VERSION = "hasLiveVersion";
        private static final String TYPE_LABEL = "type.label";
        private static final String AUDIT_TRAIL = "auditTrail";
        private DataQuery m_query;

        public ItemCollection(DataQuery query, boolean bSort) {
            super((DataCollection)new DataQueryDataCollectionAdapter(ItemCollection.doAlias(query), "item"));
            this.init(query, bSort);
        }

        public ItemCollection(DataQuery query) {
            super((DataCollection)new DataQueryDataCollectionAdapter(ItemCollection.doAlias(query), "item"));
            this.init(query, true);
        }

        private void init(DataQuery query, boolean bSort) {
            this.m_query = query;
            if (bSort) {
                this.m_query.addOrder("isFolder desc");
                this.addOrder("id desc");
            }
        }

        private static DataQuery doAlias(DataQuery query) {
            query.alias(IS_FOLDER, IS_FOLDER);
            return query;
        }

        public void setRange(Integer beginIndex, Integer endIndex) {
            this.m_dataQuery.setRange(beginIndex, endIndex);
        }

        public String getDisplayName() {
            return (String)this.get("displayName");
        }

        public Date getCreationDate() {
            DataObject dobj = (DataObject)this.get(AUDIT_TRAIL);
            if (dobj != null) {
                BasicAuditTrail audit = new BasicAuditTrail(dobj);
                return audit.getCreationDate();
            }
            return super.getCreationDate();
        }

        public Date getLastModifiedDate() {
            DataObject dobj = (DataObject)this.get(AUDIT_TRAIL);
            if (dobj != null) {
                BasicAuditTrail audit = new BasicAuditTrail(dobj);
                return audit.getLastModifiedDate();
            }
            return super.getLastModifiedDate();
        }

        public String getTypeLabel() {
            if (this.isFolder()) {
                return "Folder";
            }
            return (String)this.get(TYPE_LABEL);
        }

        public void addFolderFilter(boolean v) {
            this.m_query.addEqualsFilter(IS_FOLDER, (Object)(v ? "1" : "0"));
        }

        public boolean isFolder() {
            Boolean result = (Boolean)this.m_query.get(IS_FOLDER);
            return result;
        }

        public boolean isLive() {
            String version = (String)this.get("version");
            if ("live".equals(version)) {
                return true;
            }
            Boolean hasLive = (Boolean)this.m_query.get(HAS_LIVE_VERSION);
            return hasLive;
        }

        public BigDecimal getBundleID() {
            if (this.isFolder()) {
                return null;
            }
            return (BigDecimal)this.m_query.get("bundleID");
        }
    }
}

