/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms;

import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.ContentType;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.OID;
import com.arsdigita.util.Assert;
import com.arsdigita.workflow.simple.WorkflowTemplate;
import java.math.BigDecimal;
import org.apache.log4j.Logger;

public class ContentTypeWorkflowTemplate
extends DomainObject {
    public static final String versionId = "$Id: //cms/dev/src/com/arsdigita/cms/ContentTypeWorkflowTemplate.java#10 $$Author: dennis $$DateTime: 2004/04/07 16:07:11 $";
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$cms$ContentTypeWorkflowTemplate == null ? (class$com$arsdigita$cms$ContentTypeWorkflowTemplate = ContentTypeWorkflowTemplate.class$("com.arsdigita.cms.ContentTypeWorkflowTemplate")) : class$com$arsdigita$cms$ContentTypeWorkflowTemplate));
    public static final String BASE_DATA_OBJECT_TYPE = "com.arsdigita.cms.ContentTypeWorkflowTemplate";
    protected static final String SECTION_ID = "sectionId";
    protected static final String CONTENT_TYPE_ID = "contentTypeId";
    protected static final String WF_TEMPLATE_ID = "workflowTemplateId";
    static /* synthetic */ Class class$com$arsdigita$cms$ContentTypeWorkflowTemplate;
    static /* synthetic */ Class class$com$arsdigita$cms$ContentSection;
    static /* synthetic */ Class class$com$arsdigita$cms$ContentType;

    protected ContentTypeWorkflowTemplate() {
        super(BASE_DATA_OBJECT_TYPE);
    }

    protected ContentTypeWorkflowTemplate(OID oid) throws DataObjectNotFoundException {
        super(oid);
    }

    protected ContentTypeWorkflowTemplate(DataObject obj) {
        super(obj);
    }

    protected BigDecimal getContentSectionID() {
        return (BigDecimal)this.get(SECTION_ID);
    }

    protected BigDecimal getContentTypeID() {
        return (BigDecimal)this.get(CONTENT_TYPE_ID);
    }

    protected BigDecimal getWorkflowTemplateID() {
        return (BigDecimal)this.get(WF_TEMPLATE_ID);
    }

    protected void setContentSection(ContentSection section) {
        this.set(SECTION_ID, section.getID());
    }

    protected void setContentType(ContentType type) {
        this.set(CONTENT_TYPE_ID, type.getID());
    }

    protected void setWorkflowTemplate(WorkflowTemplate template) {
        this.set(WF_TEMPLATE_ID, template.getID());
    }

    public static WorkflowTemplate getWorkflowTemplate(ContentSection section, ContentType type) {
        if (Assert.isEnabled()) {
            Assert.exists((Object)((Object)section), (Class)(class$com$arsdigita$cms$ContentSection == null ? (class$com$arsdigita$cms$ContentSection = ContentTypeWorkflowTemplate.class$("com.arsdigita.cms.ContentSection")) : class$com$arsdigita$cms$ContentSection));
            Assert.exists((Object)((Object)type), (Class)(class$com$arsdigita$cms$ContentType == null ? (class$com$arsdigita$cms$ContentType = ContentTypeWorkflowTemplate.class$("com.arsdigita.cms.ContentType")) : class$com$arsdigita$cms$ContentType));
        }
        try {
            OID oid = new OID(BASE_DATA_OBJECT_TYPE);
            oid.set(SECTION_ID, (Object)section.getID());
            oid.set(CONTENT_TYPE_ID, (Object)type.getID());
            ContentTypeWorkflowTemplate assn = new ContentTypeWorkflowTemplate(oid);
            BigDecimal id = assn.getWorkflowTemplateID();
            return new WorkflowTemplate(new OID("com.arsdigita.workflow.simple.WorkflowTemplate", (Object)id));
        }
        catch (DataObjectNotFoundException e) {
            s_log.debug((Object)("There is no default workflow template for CT " + type.getLabel() + " in section " + section.getName()));
            return null;
        }
    }

    public static boolean updateWorkflowTemplate(ContentSection section, ContentType type, WorkflowTemplate template) {
        try {
            OID oid = new OID(BASE_DATA_OBJECT_TYPE);
            oid.set(SECTION_ID, (Object)section.getID());
            oid.set(CONTENT_TYPE_ID, (Object)type.getID());
            ContentTypeWorkflowTemplate assn = new ContentTypeWorkflowTemplate(oid);
            assn.setWorkflowTemplate(template);
            assn.save();
            return false;
        }
        catch (DataObjectNotFoundException e) {
            ContentTypeWorkflowTemplate assn = new ContentTypeWorkflowTemplate();
            assn.setContentSection(section);
            assn.setContentType(type);
            assn.setWorkflowTemplate(template);
            assn.save();
            return true;
        }
    }

    public static boolean removeWorkflowTemplate(ContentSection section, ContentType type) {
        try {
            OID oid = new OID(BASE_DATA_OBJECT_TYPE);
            oid.set(SECTION_ID, (Object)section.getID());
            oid.set(CONTENT_TYPE_ID, (Object)type.getID());
            ContentTypeWorkflowTemplate assn = new ContentTypeWorkflowTemplate(oid);
            assn.delete();
            return true;
        }
        catch (DataObjectNotFoundException e) {
            return false;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

