/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms;

import com.arsdigita.cms.ArticleImageAssnCollection;
import com.arsdigita.cms.ArticleImageAssociation;
import com.arsdigita.cms.ImageAsset;
import com.arsdigita.cms.ImageAssetCollection;
import com.arsdigita.cms.TextPage;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.persistence.DataAssociation;
import com.arsdigita.persistence.DataAssociationCursor;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.OID;
import com.arsdigita.util.Assert;
import com.arsdigita.versioning.VersionedACSObject;
import java.math.BigDecimal;
import org.apache.log4j.Logger;

public class Article
extends TextPage {
    public static final String versionId = "$Id: //cms/dev/src/com/arsdigita/cms/Article.java#27 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    public static final String BASE_DATA_OBJECT_TYPE = "com.arsdigita.cms.Article";
    protected static final String IMAGES = "imageAssets";
    private static final String IMAGE_CAPTIONS = "imageCaptions";
    private static Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$cms$Article == null ? (class$com$arsdigita$cms$Article = Article.class$("com.arsdigita.cms.Article")) : class$com$arsdigita$cms$Article));
    static /* synthetic */ Class class$com$arsdigita$cms$Article;
    static /* synthetic */ Class class$java$lang$String;

    public Article() {
        super(BASE_DATA_OBJECT_TYPE);
    }

    public Article(OID oid) throws DataObjectNotFoundException {
        super(oid);
    }

    public Article(String type) {
        super(type);
    }

    public Article(BigDecimal id) throws DataObjectNotFoundException {
        this(new OID(BASE_DATA_OBJECT_TYPE, (Object)id));
    }

    public Article(DataObject obj) {
        super(obj);
    }

    public String getBaseDataObjectType() {
        return BASE_DATA_OBJECT_TYPE;
    }

    public boolean addImage(ImageAsset image, String caption) {
        ImageAssetCollection col = this.getImages();
        col.addEqualsFilter("imageId", image.getID());
        boolean toReturn = false;
        ArticleImageAssociation assn = null;
        if (col.next()) {
            assn = (ArticleImageAssociation)col.getDomainObject();
            col.close();
        } else {
            assn = new ArticleImageAssociation();
            String name = this.getName();
            Assert.exists((Object)name, (Class)(class$java$lang$String == null ? (class$java$lang$String = Article.class$("java.lang.String")) : class$java$lang$String));
            String imgName = image.getName();
            Assert.exists((Object)imgName, (Class)(class$java$lang$String == null ? (class$java$lang$String = Article.class$("java.lang.String")) : class$java$lang$String));
            assn.setName(name + "/" + imgName);
            assn.setArticle(this);
            assn.setImage(image);
            toReturn = true;
            assn.setMaster(this);
        }
        assn.setCaption(caption);
        assn.save();
        return toReturn;
    }

    public String getCaption(ImageAsset image) {
        DataCollection col = (DataCollection)this.get(IMAGE_CAPTIONS);
        String caption = null;
        if (col.next()) {
            caption = (String)col.getDataObject().get("caption");
        }
        col.close();
        return caption;
    }

    public boolean removeImage(ImageAsset image) {
        ArticleImageAssociation assn = ArticleImageAssociation.retrieveAssociation(this.getID(), image.getID());
        if (assn != null) {
            assn.delete();
            return true;
        }
        return false;
    }

    public ImageAssetCollection getImages() {
        DataAssociationCursor dac = ((DataAssociation)this.get(IMAGE_CAPTIONS)).cursor();
        ArticleImageAssnCollection images = new ArticleImageAssnCollection((DataCollection)dac);
        return images;
    }

    public void clearImages() {
        ImageAssetCollection images = this.getImages();
        while (images.next()) {
            images.getDomainObject().delete();
        }
    }

    protected void propagateMaster(VersionedACSObject master) {
        super.propagateMaster(master);
        ImageAssetCollection collection = this.getImages();
        while (collection.next()) {
            ArticleImageAssociation assn = (ArticleImageAssociation)collection.getDomainObject();
            assn.setMaster(master);
            assn.save();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

