/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.ui.workflow;

import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.cms.ui.BaseDeleteForm;
import com.arsdigita.workflow.simple.Workflow;

/*
 * @author Justin Ross &lt;jross@redhat.com&gt;
 * @version $Id: //cms/dev/src/com/arsdigita/cms/ui/workflow/WorkflowDeleteForm.java#6 $
 */

class WorkflowDeleteForm extends BaseDeleteForm {
    public static final String versionId =
        "$Id: //cms/dev/src/com/arsdigita/cms/ui/workflow/WorkflowDeleteForm.java#6 $" +
        "$Author: dennis $" +
        "$DateTime: 2004/04/07 16:07:11 $";

    final WorkflowRequestLocal m_workflow;

    WorkflowDeleteForm(final WorkflowRequestLocal workflow) {
        super(new Label(gz("cms.ui.workflow.delete_prompt")));

        m_workflow = workflow;
    }

    public final void process(final FormSectionEvent e)
            throws FormProcessException {
        final Workflow workflow = m_workflow.getWorkflow(e.getPageState());

        workflow.delete();
    }
}
