/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.ui.workflow;


import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SimpleComponent;
import com.arsdigita.cms.CMS;
import com.arsdigita.workflow.simple.Workflow;
import com.arsdigita.xml.Element;

public class WorkflowComponent extends SimpleComponent {

    public static final String versionId = "$Id: //cms/dev/src/com/arsdigita/cms/ui/workflow/WorkflowComponent.java#7 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    Workflow m_workflow;
    public WorkflowComponent(Workflow w) {
        m_workflow = w;
    }

    public void generateXML(PageState state, Element parent) {
        Element element = new Element("cms:workflow", CMS.CMS_XML_NS);
        parent.addContent(element);
        exportAttributes(element);
        element.addAttribute("name", m_workflow.getLabel());
        element.addAttribute("state", m_workflow.getStateString());
        element.addAttribute("process-state", String.valueOf
                             (m_workflow.getProcessState()));
        element.addAttribute("description", m_workflow.getDescription());
        element.addAttribute("count",
                             String.valueOf(m_workflow.getTaskCount()));

    }
}
