/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.ui.workflow;

import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.event.FormInitListener;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.PrintEvent;
import com.arsdigita.bebop.event.PrintListener;
import com.arsdigita.bebop.form.Option;
import com.arsdigita.bebop.form.OptionGroup;
import com.arsdigita.cms.workflow.CMSTask;
import com.arsdigita.util.UncheckedWrapperException;
import com.arsdigita.workflow.simple.Task;
import com.arsdigita.workflow.simple.TaskCollection;
import org.apache.log4j.Logger;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.TooManyListenersException;

/**
 * @author Justin Ross
 * @version $Id: //cms/dev/src/com/arsdigita/cms/ui/workflow/TaskEditForm.java#5 $
 */
class TaskEditForm extends BaseTaskForm {
    public static final String versionId =
        "$Id: //cms/dev/src/com/arsdigita/cms/ui/workflow/TaskEditForm.java#5 $" +
        "$Author: dennis $" +
        "$DateTime: 2004/04/07 16:07:11 $";

    private static final Logger s_log = Logger.getLogger(TaskEditForm.class);

    private TaskRequestLocal m_task;

    public TaskEditForm(final WorkflowRequestLocal workflow,
                        final TaskRequestLocal task) {
        super("task", gz("cms.ui.workflow.task.edit"), workflow);

        m_task = task;

        try {
            m_deps.addPrintListener(new DependencyPrinter());
        } catch (TooManyListenersException tmle) {
            throw new UncheckedWrapperException(tmle);
        }

        addInitListener(new InitListener());
        addProcessListener(new ProcessListener());
    }

    private class DependencyPrinter implements PrintListener {
        public final void prepare(final PrintEvent e) {
            final PageState state = e.getPageState();
            final TaskCollection tasks = m_workflow.getWorkflow
                (state).getTaskCollection();

            final OptionGroup options = (OptionGroup) e.getTarget();

            while (tasks.next()) {
                final Task task = tasks.getTask();

                if (!m_task.getTask(state).getID().equals(task.getID())) {
                    options.addOption(new Option(task.getID().toString(),
                                                 task.getLabel()));
                }
            }
        }
    }

    private class InitListener implements FormInitListener {
        public final void init(final FormSectionEvent e)
                throws FormProcessException {
            final PageState state = e.getPageState();
            final CMSTask task = m_task.getTask(state);

            m_name.setValue(state, task.getLabel());
            m_description.setValue(state, task.getDescription());
            m_type.setValue(state, task.getTaskType());

            final TaskCollection deps = task.getRequiredTasks();
            final ArrayList list = new ArrayList();

            while (deps.next()) {
                list.add(deps.getTask().getID().toString());
            }

            m_deps.setValue(state, list.toArray());
        }
    }

    private class ProcessListener implements FormProcessListener {
        public final void process(final FormSectionEvent e)
                throws FormProcessException {
            final PageState state = e.getPageState();
            final CMSTask task = m_task.getTask(state);

            task.setLabel((String) m_name.getValue(state));
            task.setDescription((String) m_description.getValue(state));
            task.setTaskType((BigDecimal) m_type.getValue(state));

            // XXX Is this necessary?
            task.save();

            processDependencies(task, (String[]) m_deps.getValue(state));

            task.save();
        }
    }
}
