/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.ui.workflow;



import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.event.PrintEvent;
import com.arsdigita.bebop.event.PrintListener;
import com.arsdigita.bebop.form.Option;
import com.arsdigita.bebop.form.OptionGroup;
import com.arsdigita.workflow.simple.Task;
import com.arsdigita.workflow.simple.TaskCollection;


/**
 * Builds a list of workflow templates registered to the current
 * content section.
 *
 * @author Uday Mathur (umathur@arsdigita.com)
 * @version $Revision: #6 $ $Date: 2004/04/07 $
 */

public abstract class TaskCollectionOptionPrintListener implements PrintListener {

    public static final String versionId = "$Id: //cms/dev/src/com/arsdigita/cms/ui/workflow/TaskCollectionOptionPrintListener.java#6 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    abstract TaskCollection getCollection(PageState state);

    public void prepare(PrintEvent e) {
        PageState s = e.getPageState();
        OptionGroup w = (OptionGroup) e.getTarget();
        TaskCollection t = getCollection(s);

        while (t.next()) {
            Task task = (Task)t.getDomainObject();
            w.addOption(new Option(task.getID().toString(),
                                   task.getLabel()));
        }
    }

}
