/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.ui.workflow;

import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SingleSelectionModel;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.PrintEvent;
import com.arsdigita.bebop.event.PrintListener;
import com.arsdigita.bebop.form.Option;
import com.arsdigita.bebop.form.OptionGroup;
import com.arsdigita.cms.workflow.CMSTask;
import com.arsdigita.util.UncheckedWrapperException;
import com.arsdigita.workflow.simple.Task;
import com.arsdigita.workflow.simple.TaskCollection;
import com.arsdigita.workflow.simple.Workflow;
import org.apache.log4j.Logger;

import java.math.BigDecimal;
import java.util.TooManyListenersException;

/**
 * @author Justin Ross
 * @version $Id: //cms/dev/src/com/arsdigita/cms/ui/workflow/TaskAddForm.java#5 $
 */
class TaskAddForm extends BaseTaskForm {
    public static final String versionId =
        "$Id: //cms/dev/src/com/arsdigita/cms/ui/workflow/TaskAddForm.java#5 $" +
        "$Author: dennis $" +
        "$DateTime: 2004/04/07 16:07:11 $";

    private static final Logger s_log = Logger.getLogger(TaskAddForm.class);

    protected final static String ERROR_MSG =
        "A workflow template with that name already exists in this content " +
        "section.";

    private final SingleSelectionModel m_model;

    public TaskAddForm(final WorkflowRequestLocal workflow,
                       final SingleSelectionModel model) {
        super("task", gz("cms.ui.workflow.task.add"), workflow);

        m_model = model;

        try {
            m_deps.addPrintListener(new DependencyPrinter());
        } catch (TooManyListenersException tmle) {
            throw new UncheckedWrapperException(tmle);
        }

        addProcessListener(new ProcessListener());
    }

    private class DependencyPrinter implements PrintListener {
        public final void prepare(final PrintEvent e) {
            final PageState state = e.getPageState();
            final TaskCollection tasks = m_workflow.getWorkflow
                (state).getTaskCollection();

            final OptionGroup options = (OptionGroup) e.getTarget();

            while (tasks.next()) {
                final Task task = tasks.getTask();

                options.addOption(new Option(task.getID().toString(),
                                             task.getLabel()));
            }
        }
    }

    private class ProcessListener implements FormProcessListener {
        public final void process(final FormSectionEvent e)
                throws FormProcessException {
            final PageState state = e.getPageState();

            final Workflow workflow = m_workflow.getWorkflow(state);
            final CMSTask task = new CMSTask();

            task.setLabel((String) m_name.getValue(state));
            task.setDescription((String) m_description.getValue(state));
            task.setTaskType((BigDecimal) m_type.getValue(state));
            task.setActive(true);

            task.save();

            // XXX Why are we doing this?
            workflow.save();

            workflow.addTask(task);

            processDependencies(task, (String[]) m_deps.getValue(state));

            task.save();

            m_model.setSelectedKey(state, task.getID().toString());
        }
    }
}
