/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.ui.util;

import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.ToggleLink;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.FormSubmissionListener;


/**
 * This class implements the FormProcessListener and FormSubmissionListener
 * The primary function of this class is to reset the ToggleLink to a
 * particular state after a form is processed or submitted.
 *
 * @author Jack Chung (flattop@arsdigita.com)
 * @version $Revision: #6 $ $Date: 2004/04/07 $
 */
public class ToggleLinkFormListener
    implements FormProcessListener, FormSubmissionListener {

    public static final String versionId = "$Id: //cms/dev/src/com/arsdigita/cms/ui/util/ToggleLinkFormListener.java#6 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    private ToggleLink m_toggleLink;
    private boolean m_isSelected;

    /**
     * Default Constructor.  Toggle link will be deselected when form is
     * processed or submitted
     *
     * @param l The toggle Link
     */
    public ToggleLinkFormListener(ToggleLink l) {
        this(l, false);
    }

    /**
     * Constructor.
     *
     * @param l The toggle Link
     * @param isSelected Specify true if the toggle link should be
     *   selected when form is processed or submited, false otherwise.
     */
    public ToggleLinkFormListener(ToggleLink l, boolean isSelected) {
        m_toggleLink = l;
        m_isSelected = isSelected;
    }

    /**
     * Returns the toggle link
     */
    public ToggleLink getToggleLink() {
        return m_toggleLink;
    }

    /**
     * Returns whether the toggle link should be selected after the form
     * is processed.
     */
    public boolean getIsSelected() {
        return m_isSelected;
    }

    /**
     * Set whether the toggle link should be selected after the form
     * is processed.
     *
     * @param isSelected Specify true if the toggle link should be
     *   selected when form is processed or submitted, false otherwise.
     */
    public void getIsSelected(boolean isSelected) {
        m_isSelected = isSelected;
    }

    public void process(FormSectionEvent e) throws FormProcessException {
        PageState state = e.getPageState();

        //update the state of the toggle link
        m_toggleLink.setSelected(state, m_isSelected);
    }

    public void submitted(FormSectionEvent e) throws FormProcessException {
        process(e);
    }

}
