/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.ui.type;


import com.arsdigita.bebop.ColumnPanel;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.form.CheckboxGroup;
import com.arsdigita.bebop.form.Option;
import com.arsdigita.cms.util.GlobalizationUtil;
import com.arsdigita.formbuilder.PersistentForm;
import com.arsdigita.formbuilder.PersistentTextField;
import com.arsdigita.kernel.ui.ACSObjectSelectionModel;
import com.arsdigita.metadata.DynamicObjectType;
import com.arsdigita.persistence.metadata.MetadataRoot;


/**
 * This class contains the form component for adding a number element to
 * a content type
 *
 * @author Xixi D'Moon (xdmoon@arsdigita.com)
 * @author Stanislav Freidin (sfreidin@arsdigita.com)
 * @version $Revision: #12 $ $Date: 2004/04/07 $
 */
public class AddNumberElement extends ElementAddForm {

    private CheckboxGroup m_valReq;  //whether a value is requred

    /**
     * Constructor
     */
    public AddNumberElement(ACSObjectSelectionModel types) {
        super("ContentTypeAddNumberElement", "Add a Number Element", types);

        add(new Label(GlobalizationUtil.globalize("cms.ui.type.element.value_required")));
        m_valReq = new CheckboxGroup("AddNumberElementValReq");
        m_valReq.addOption(new Option("yes", "Yes"));
        add(m_valReq);

        add(m_buttons, ColumnPanel.FULL_WIDTH|ColumnPanel.CENTER);
    }

    protected final void addAttribute(DynamicObjectType dot, String label,
                                      PageState state)
        throws FormProcessException {

        String[] valReq = (String[]) m_valReq.getValue(state);

        if (valReq == null) {
            dot.addOptionalAttribute(label, MetadataRoot.BIGDECIMAL);
        } else {
            dot.addRequiredAttribute(label, MetadataRoot.BIGDECIMAL, "0");
        }
    }

    protected final void addFormComponent(PersistentForm pForm, String label,
                                          PageState state)
        throws FormProcessException {

        PersistentTextField pTextField = PersistentTextField.create(label);
        pTextField.setParameterModel
            ("com.arsdigita.bebop.parameters.BigDecimalParameter");
        pTextField.save();
        pForm.addComponent(pTextField);
    }
}
