/*
 * Copyright (C) 2002-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.ui.type;

import com.arsdigita.bebop.ColumnPanel;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.PageState;
import com.arsdigita.cms.FileAsset;
import com.arsdigita.formbuilder.PersistentForm;
import com.arsdigita.formbuilder.PersistentHidden;
import com.arsdigita.kernel.ui.ACSObjectSelectionModel;
import com.arsdigita.metadata.DynamicObjectType;
import com.arsdigita.persistence.metadata.MetadataRoot;

/**
 * This class contains the form component for adding a File element to
 * a content type
 *
 * @author Scott Seago (scott@arsdigita.com)
 * @version $Revision: #12 $ $Date: 2004/04/07 $
 */
public class AddFileElement extends ElementAddForm {

    public static final String ACTION_NONE = "none";
    public static final String ACTION_UPLOAD = "upload";
    public static final String ACTION_DELETE = "delete";
    public static final String ACTION = "action";

    /**
     * Constructor
     */
    public AddFileElement(ACSObjectSelectionModel types) {
        super("ContentTypeAddFileElement", "Add a File Element", types);

        add(m_buttons, ColumnPanel.FULL_WIDTH|ColumnPanel.CENTER);
    }


    protected final void addAttribute(DynamicObjectType dot, String label,
                                      PageState state)
        throws FormProcessException {

        dot.addOptionalAssociation(label,
                                   MetadataRoot.getMetadataRoot().getObjectType
                                   (FileAsset.BASE_DATA_OBJECT_TYPE));
    }


    protected final void addFormComponent(PersistentForm pForm, String label,
                                          PageState state)
        throws FormProcessException {

        PersistentHidden pFile = PersistentHidden.create(label);
        pFile.setDefaultValue(label+".file");
        pFile.save();
        pForm.addComponent(pFile);
    }
}
