/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.ui.role;

import com.arsdigita.bebop.list.ListModel;
import com.arsdigita.kernel.RoleCollection;

class RoleListModel implements ListModel {
    private final RoleCollection m_roles;

    public RoleListModel(RoleCollection roles) {
        m_roles = roles;
    }

    public final boolean next() {
        return m_roles.next();
    }

    public final Object getElement() {
        return m_roles.getRole().getName();
    }

    public final String getKey() {
        return m_roles.getRole().getID().toString();
    }

    public final boolean isEmpty() {
        return m_roles.isEmpty();
    }

    public final void reset() {
        m_roles.reset();
    }
}
