/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.ui.role;

import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.Table;
import com.arsdigita.bebop.table.AbstractTableModelBuilder;
import com.arsdigita.bebop.table.TableModel;
import com.arsdigita.cms.util.GlobalizationUtil;
import com.arsdigita.kernel.EmailAddress;
import com.arsdigita.kernel.Party;
import com.arsdigita.kernel.PartyCollection;
import com.arsdigita.kernel.Role;
import org.apache.log4j.Logger;

/**
 * @author Justin Ross &lt;jross@redhat.com&gt;
 * @version $Id: //cms/dev/src/com/arsdigita/cms/ui/role/MemberTableModelBuilder.java#6 $
 */
class MemberTableModelBuilder extends AbstractTableModelBuilder {
    public static final String versionId =
        "$Id: //cms/dev/src/com/arsdigita/cms/ui/role/MemberTableModelBuilder.java#6 $" +
        "$Author: dennis $" +
        "$DateTime: 2004/04/07 16:07:11 $";

    private static final Logger s_log = Logger.getLogger
        (MemberTableModelBuilder.class);

    private final RoleRequestLocal m_role;

    MemberTableModelBuilder(final RoleRequestLocal role) {
        m_role = role;
    }

    public final TableModel makeModel(final Table table,
                                      final PageState state) {
        final Role role = m_role.getRole(state);

        return new Model(role.getContainedParties());
    }

    private static class Model implements TableModel {
        private Party m_party;
        private final PartyCollection m_parties;

        Model(final PartyCollection parties) {
            m_parties = parties;
        }

        public final int getColumnCount() {
            return 3;
        }

        public final boolean nextRow() {
            if (m_parties.next()) {
                m_party = m_parties.getParty();

                return true;
            } else {
                m_parties.close();

                return false;
            }
        }

        public final Object getKeyAt(final int column) {
            return m_party.getID();
        }

        public final Object getElementAt(final int column) {
            switch (column) {
            case 0:
                return m_party.getDisplayName();
            case 1:
                final EmailAddress email = m_party.getPrimaryEmail();

                if (email == null) {
                    return lz("cms.ui.none");
                } else {
                    return email.toString();
                }
            case 2:
                return lz("cms.ui.role.member.remove");
            default:
                throw new IllegalStateException();
            }
        }
    }

    protected final static String lz(final String key) {
        return (String) GlobalizationUtil.globalize(key).localize();
    }
}
