/*
 * Copyright (C) 2002-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.ui.permissions;


import com.arsdigita.bebop.ColumnPanel;
import com.arsdigita.bebop.Form;
import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.form.Submit;
import com.arsdigita.bebop.form.TextField;
import com.arsdigita.bebop.parameters.NotEmptyValidationListener;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.bebop.parameters.StringParameter;
import com.arsdigita.kernel.Party;
import com.arsdigita.kernel.PartyCollection;
import com.arsdigita.kernel.permissions.PrivilegeDescriptor;
import com.arsdigita.util.StringUtils;

/**
 * User Search Form for permissions.
 *
 * @author Stefan Deusch (stefan@arsdigita.com)
 * @version $Id: //cms/dev/src/com/arsdigita/cms/ui/permissions/CMSUserSearchForm.java#9 $
 */

public class CMSUserSearchForm extends Form
    implements FormProcessListener,  CMSPermissionsConstants
{
    private CMSPermissionsPane m_parent;
    private TextField m_search;

    public CMSUserSearchForm(CMSPermissionsPane parent) {
        this(DEFAULT_PRIVILEGES, parent);
    }

    public CMSUserSearchForm(PrivilegeDescriptor[] privs, CMSPermissionsPane parent) {
        super("RoleSearchUsers", new SimpleContainer());

        m_parent = parent;
        setMethod(Form.POST);

        addProcessListener(this);

        add(new Label(SEARCH_LABEL));
        add(new Label("&nbsp;", false));

        StringParameter searchParam = new StringParameter(SEARCH_QUERY);
        m_search = new TextField(searchParam);
        m_search.addValidationListener(new NotEmptyValidationListener());
        m_search.setSize(20);
        add(m_search, ColumnPanel.RIGHT);

        Submit submit = new Submit("submit");
        submit.setButtonLabel(SEARCH_BUTTON);
        add(submit, ColumnPanel.LEFT);
    }


    public void process (FormSectionEvent e)
        throws FormProcessException {
        PageState state = e.getPageState();
        FormData data = e.getFormData();
        String search = (String)data.get(SEARCH_QUERY);
        search = StringUtils.stripWhiteSpace(search);

        PartyCollection parties = Party.retrieveAllParties();
        parties.filter(search);

        // DataQuery query = SessionManager.getSession().
        //     retrieveQuery(RETRIEVE_USERS);
        // query.setParameter("excludeGroupId", null);
        // Filter f = query.addFilter
        //     ("searchName like lower('%' || :searchQuery || '%')");
        // f.set("searchQuery", search);

        if (parties.isEmpty()) {
            m_parent.showNoResults(state);
        } else {
            // put search string into Page
            state.setValue(getSearchString(), data.get(SEARCH_QUERY));

            // put privileges into Page
            state.setValue(getPrivilegeModel(), getPrivileges());

            m_parent.showGrant(state);
        }
        parties.close();
        // clear query string
    }

    /**
     * Hide Delegate pattern, if parent's implementation changes.
     */
    private ParameterModel getSearchString() {
        return m_parent.getSearchString();
    }

    /**
     * Detto
     */
    private ParameterModel getPrivilegeModel() {
        return m_parent.getPrivilegeParam();
    }

    /**
     * Detto
     */
    private Object[] getPrivileges() {
        return (Object[])m_parent.getPrivileges();
    }

    public TextField getSearchWidget() {
        return m_search;
    }
}
