/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.ui.lifecycle;

import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.event.FormInitListener;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.cms.lifecycle.LifecycleDefinition;
import org.apache.log4j.Logger;

/**
 * This class contains a form component to edit a lifecycle
 * definition.
 *
 * @author Jack Chung
 * @author Xixi D'Moon &lt;xdmoon@redhat.com&gt;
 * @author Justin Ross &lt;jross@redhat.com&gt;
 * @version $Id: //cms/dev/src/com/arsdigita/cms/ui/lifecycle/LifecycleEditForm.java#9 $
 */
class LifecycleEditForm extends BaseLifecycleForm {
    public static final String versionId =
        "$Id: //cms/dev/src/com/arsdigita/cms/ui/lifecycle/LifecycleEditForm.java#9 $" +
        "$Author: dennis $" +
        "$DateTime: 2004/04/07 16:07:11 $";

    private static final Logger s_log = Logger.getLogger
        (LifecycleEditForm.class);

    private LifecycleDefinitionRequestLocal m_definition;

    LifecycleEditForm(final LifecycleDefinitionRequestLocal definition) {
        super("LifecycleEdit", gz("cms.ui.lifecycle.edit"));

        m_definition = definition;

        m_name.addValidationListener(new NameUniqueListener(m_definition));

        addInitListener(new InitListener());
        addProcessListener(new ProcessListener());
    }

    private class InitListener implements FormInitListener {
        public final void init(final FormSectionEvent e) {
            final PageState state = e.getPageState();
            final LifecycleDefinition cycle = m_definition.getLifecycleDefinition
                (state);

            m_name.setValue(state, cycle.getLabel());
            m_description.setValue(state, cycle.getDescription());
        }
    }

    private class ProcessListener implements FormProcessListener {
        public final void process(final FormSectionEvent e)
                throws FormProcessException {
            final PageState state = e.getPageState();
            final LifecycleDefinition definition =
                m_definition.getLifecycleDefinition(state);

            definition.setLabel((String) m_name.getValue(state));
            definition.setDescription((String) m_description.getValue(state));
            definition.save();
        }
    }
}
