/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.ui.lifecycle;

import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SingleSelectionModel;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.cms.CMS;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.lifecycle.LifecycleDefinition;
import org.apache.log4j.Logger;

/**
 * @author Michael Pih
 * @author Jack Chung
 * @author Xixi D'Moon &lt;xdmoon@redhat.com&gt;
 * @author Justin Ross &lt;jross@redhat.com&gt;
 * @version $Id: //cms/dev/src/com/arsdigita/cms/ui/lifecycle/LifecycleAddForm.java#7 $
 */
class LifecycleAddForm extends BaseLifecycleForm {
    public static final String versionId =
        "$Id: //cms/dev/src/com/arsdigita/cms/ui/lifecycle/LifecycleAddForm.java#7 $" +
        "$Author: dennis $" +
        "$DateTime: 2004/04/07 16:07:11 $";

    private static final Logger s_log = Logger.getLogger
        (LifecycleAddForm.class);

    private final SingleSelectionModel m_model;

    LifecycleAddForm(final SingleSelectionModel model) {
        super("LifecycleDefinition", gz("cms.ui.lifecycle.add"));

        m_model = model;

        m_name.addValidationListener(new NameUniqueListener(null));

        addProcessListener(new ProcessListener());
    }

    private class ProcessListener implements FormProcessListener {
        public final void process(final FormSectionEvent e)
                throws FormProcessException {
            final PageState state = e.getPageState();

            final LifecycleDefinition definition = new LifecycleDefinition();
            definition.setLabel((String) m_name.getValue(state));
            definition.setDescription((String) m_description.getValue(state));
            definition.save();

            final ContentSection section =
                CMS.getContext().getContentSection();
            section.addLifecycleDefinition(definition);
            section.save();

            m_model.setSelectedKey(state, definition.getID().toString());
        }
    }
}
