/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.ui.folder;

import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.RequestLocal;
import com.arsdigita.bebop.SingleSelectionModel;
import com.arsdigita.cms.Folder;
import com.arsdigita.cms.ui.ACSObjectRequestLocal;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.util.UncheckedWrapperException;
import org.apache.log4j.Logger;

import java.math.BigDecimal;

public class FolderRequestLocal extends ACSObjectRequestLocal {
    public static final String versionId =
        "$Id: //cms/dev/src/com/arsdigita/cms/ui/folder/FolderRequestLocal.java#6 $" +
        "$Author: dennis $" +
        "$DateTime: 2004/04/07 16:07:11 $";

    private static final Logger s_log = Logger.getLogger
        (FolderRequestLocal.class);

    private final SingleSelectionModel m_model;

    public FolderRequestLocal(final SingleSelectionModel model) {
        m_model = model;
    }

    public FolderRequestLocal() {
        m_model = null;
    }

    protected Object initialValue(final PageState state) {
        if (m_model == null) {
            return null;
        } else {
            final String id = m_model.getSelectedKey(state).toString();

            return new Folder(new BigDecimal(id));
        }
    }

    public final Folder getFolder(final PageState state) {
        return (Folder) get(state);
    }
}
