/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.ui.category;

import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.List;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SingleSelectionModel;
import com.arsdigita.bebop.event.ActionEvent;
import com.arsdigita.bebop.event.ActionListener;
import com.arsdigita.bebop.list.ListModel;
import com.arsdigita.bebop.list.ListModelBuilder;
import com.arsdigita.categorization.Category;
import com.arsdigita.categorization.CategoryCollection;
import com.arsdigita.cms.util.GlobalizationUtil;
import com.arsdigita.util.LockableImpl;

/**
 * A List of all subcategories of the current category.
 *
 * @author Stanislav Freidin (stas@arsdigita.com)
 * @author Michael Pih (pihman@arsdigita.com)
 * @version $Revision: #14 $ $DateTime: 2004/04/07 16:07:11 $
 */
public class SubcategoryList extends SortableCategoryList {
    private final CategoryRequestLocal m_parent;
    private final SingleSelectionModel m_model;

    public SubcategoryList(final CategoryRequestLocal parent,
                           final SingleSelectionModel model) {
        super(parent);

        m_parent = parent;
        m_model = model;

        setIdAttr("subcategories_list");

        setModelBuilder(new SubcategoryModelBuilder());

        // Select the category in the main tree when the
        // user selects it here
        addActionListener(new ActionListener() {
                public void actionPerformed(ActionEvent event) {
                    final PageState state = event.getPageState();
                    final String id = (String) getSelectedKey(state);

                    if (id != null) {
                        m_model.setSelectedKey(state, id);
                    }
                }
            });

        Label label = new Label(GlobalizationUtil.globalize
                                ("cms.ui.category.subcategory.none"));
        label.setFontWeight(Label.ITALIC);
        setEmptyView(label);
    }

    private class SubcategoryModelBuilder extends LockableImpl
            implements ListModelBuilder {
        public ListModel makeModel(List list, PageState state) {
            final Category category = m_parent.getCategory(state);

            if (category != null && category.hasChildCategories()) {
                CategoryCollection children = category.getChildren();
                children.addOrder("link." + Category.SORT_KEY);
                return new CategoryCollectionListModel(children);
            } else {
                return List.EMPTY_MODEL;
            }
        }
    }
}
