/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.ui.category;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.PageState;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.kernel.Party;
import com.arsdigita.kernel.permissions.PermissionDescriptor;
import com.arsdigita.kernel.permissions.PermissionService;
import com.arsdigita.kernel.permissions.PrivilegeDescriptor;
import com.arsdigita.kernel.ui.ACSObjectSelectionModel;
import com.arsdigita.toolbox.ui.SecurityContainer;


/**
 * Container that wraps category admin access checks around UI components.
 *
 * @author Michael Pih (pihman@arsdigita.com)
 * @version $Revision: #8 $ $DateTime: 2004/04/07 16:07:11 $
 */
public class CategoryAdminContainer extends SecurityContainer {

    public static final String versionId = "$Id: //cms/dev/src/com/arsdigita/cms/ui/category/CategoryAdminContainer.java#8 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    private ACSObjectSelectionModel m_object;
    private PrivilegeDescriptor m_priv;

    public CategoryAdminContainer(Component c,
                                  ACSObjectSelectionModel object,
                                  PrivilegeDescriptor priv) {
        super(c);
        m_object = object;
        m_priv = priv;
    }

    public boolean canAccess(Party party, PageState state) {
        return PermissionService.checkPermission(
            new PermissionDescriptor(
                m_priv,
                (ACSObject) m_object.getSelectedObject(state),
                party));
    }
}
