/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.ui.authoring;

import com.arsdigita.bebop.Container;
import com.arsdigita.bebop.SaveCancelSection;
import com.arsdigita.bebop.event.FormProcessListener;

/**
 * Interface which item creation components should implement. It's
 * currently an optional interface, but user defined content types
 * will not work unless they inherit from a type whose creation
 * component implements this. This interface currently only defines
 * methods which are essential to the operation of UDCT creation
 * components.
 *
 * @author Scott Seago (sseago@redhat.com)
 * @version $Revision: #3 $ $DateTime: 2004/04/07 16:07:11 $
 */
public interface CreationComponent extends Container, FormProcessListener {

    /**
     * Instantiate and add the save/cancel section for this CreationComponent.
     */
    void addSaveCancelSection();

    /**
     * Return the save/cancel section for this CreationComponent.
     *
     * @return the save/cancel section for this CreationComponent.
     */
    SaveCancelSection getSaveCancelSection();

    /**
     * Removes the specified process listener from the
     * list of process listeners (if it had previously been added).
     *
     * @param listener the process listener to remove
     */
    void removeProcessListener(FormProcessListener listener);

    /**
     * Return the ApplyWorkflowFormSection associated with this CreationComponent.
     *
     * @return the ApplyWorkflowFormSection associated with this CreationComponent.
     */
    ApplyWorkflowFormSection getWorkflowSection();

}
