/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.ui;


import com.arsdigita.bebop.ColumnPanel;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.form.Submit;
import com.arsdigita.bebop.form.TextField;
import com.arsdigita.bebop.parameters.StringParameter;
import com.arsdigita.cms.util.GlobalizationUtil;


/**
 * Form to search for users to be added to a staff group.
 *
 * @author Michael Pih (pihman@arsdigita.com)
 * @version $Revision: #12 $ $Date: 2004/04/07 $
 */
public class UserSearchForm extends CMSForm {

    public static final String versionId = "$Id: //cms/dev/src/com/arsdigita/cms/ui/UserSearchForm.java#12 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    private final static String SEARCH_LABEL = "Search";

    private TextField m_search;


    public UserSearchForm(String name) {
        this(name,
             new Label(GlobalizationUtil.globalize("cms.ui.search_to_add_new_members")));

    }

    public UserSearchForm(String name, Label heading) {
        super(name, new ColumnPanel(3));
        heading.setFontWeight(Label.BOLD);
        add(heading, ColumnPanel.FULL_WIDTH);

        add(new Label(GlobalizationUtil.globalize("cms.ui.enter_first_name_last_name_andor_email_address")));

        m_search = new TextField(new StringParameter("query"));
        m_search.setSize(20);
        add(m_search, ColumnPanel.RIGHT);

        Submit submit = new Submit("submit");
        submit.setButtonLabel(SEARCH_LABEL);
        add(submit, ColumnPanel.LEFT);
    }

    public TextField getSearchWidget() {
        return m_search;
    }

}
