/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.ui;


import com.arsdigita.bebop.PageState;
import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.dispatcher.CMSPage;
import com.arsdigita.cms.dispatcher.ItemResolver;
import com.arsdigita.cms.util.GlobalizationUtil;
import com.arsdigita.dispatcher.DispatcherHelper;
import com.arsdigita.dispatcher.RequestContext;
import com.arsdigita.util.UncheckedWrapperException;
import java.io.IOException;
import java.math.BigDecimal;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;


/**
 * Page for redirecting results of Search to the item to be
 * displayed.
 *
 * @author Jeff Teeters (teeters@arsdigita.com)
 * @version $Revision: #10 $ $Date: 2004/04/07 $
 *
 */
public class SearchResultRedirector extends CMSPage /* implements ActionListener */ {

    public static final String versionId = "$Id: //cms/dev/src/com/arsdigita/cms/ui/SearchResultRedirector.java#10 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    /**
     * Names of required parameters passed in the request
     */
    public static final String ITEM_ID = "item_id";
    public static final String CONTEXT = "context";
    private static final  Logger s_log = Logger.getLogger(SearchResultRedirector.class);

    /**
     * Construct a new SearchResultRedirector
     */
    public SearchResultRedirector() {
        super();
    }


    /***
     * override dispatcher to do redirect to page displaying item.
     ***/
    public void dispatch(HttpServletRequest req,
                         HttpServletResponse resp, RequestContext actx) {

        // Get item_id
        BigDecimal id;

        try {
            id = new BigDecimal(getParam(ITEM_ID, req));
        } catch (NumberFormatException e) {
            s_log.error("Invalid CMS Item id", e);
	    String itemID = (String) getParam(ITEM_ID,req);
            throw new RuntimeException( (String) GlobalizationUtil.globalize(
            "cms.ui.invalid_item_id", new Object[] { itemID }).localize() + e.getMessage());
        }

        // Get context
        String context = getParam(CONTEXT, req);

        // Get section and item
        ContentSection section;
        ContentItem item = new ContentItem(id);
        section = item.getContentSection();

        // Get url
        ItemResolver resolver = section.getItemResolver();
        PageState state;
        try {
            state = new PageState(this, req, resp);
        } catch (javax.servlet.ServletException ex) {
            throw new UncheckedWrapperException("Servlet Error: " + ex.getMessage(), ex);
        }
        String url = resolver.generateItemURL ( state, item, section, context );

        // redirect to url
        try {
            DispatcherHelper.sendRedirect(req, resp, url);
        } catch (IOException e) {
            UncheckedWrapperException.throwLoggedException(getClass(), "Could not redirect: " + e.getMessage(), e );
        }
    }


    /**
     * Get a parameter from the request
     */

    private String getParam ( String paramName, HttpServletRequest req) {
        String [] params = req.getParameterValues(paramName);
        if (params.length != 1) {
            s_log.error("Not one " + paramName);
            throw new RuntimeException("Not one " + paramName);
        }
        return params[0];
    }
}
