/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.ui;


import com.arsdigita.bebop.PageState;
import com.arsdigita.cms.dispatcher.CMSPage;
import com.arsdigita.cms.dispatcher.Utilities;
import com.arsdigita.cms.util.GlobalizationUtil;
import com.arsdigita.dispatcher.DispatcherHelper;
import com.arsdigita.kernel.KernelRequestContext;
import com.arsdigita.kernel.security.UserContext;
import java.io.IOException;
import javax.security.auth.login.LoginException;
import javax.servlet.ServletException;
import org.apache.log4j.Logger;


/**
 * A page that logs the current user out
 *
 * @author Michael Pih (pihman@arsdigita.com)
 * @version $Revision: #11 $
 */
public class Logout extends CMSPage {

    public static final String versionId = "$Id: //cms/dev/src/com/arsdigita/cms/ui/Logout.java#11 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    final static String URL_AFTER_LOGOUT = Utilities.getWebappContext() + "/";

    private static final Logger s_log = Logger.getLogger(Logout.class);
    public Logout() {
        super();
    }

    public void process(PageState state) throws ServletException {

        try {
            KernelRequestContext kctx = (KernelRequestContext)
                DispatcherHelper.getRequestContext(state.getRequest());
            UserContext uctx = kctx.getUserContext();
            uctx.logout();

        } catch (LoginException e) {
            s_log.error("Error logging out", e);
            throw new ServletException( (String) GlobalizationUtil.globalize("cms.ui.logout_failed").localize(),  e);
        }

        try {
            state.getResponse().sendRedirect(URL_AFTER_LOGOUT);
        } catch (IOException e) {
            throw new ServletException(e);
        }
    }
}
