/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.ui;


import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Container;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.List;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.Page;
import com.arsdigita.bebop.form.Option;
import com.arsdigita.bebop.form.RadioGroup;
import com.arsdigita.bebop.form.Submit;
import com.arsdigita.bebop.list.ListCellRenderer;
import com.arsdigita.toolbox.ui.OIDParameter;
import com.arsdigita.persistence.OID;
import com.arsdigita.cms.ContentItem;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.globalization.GlobalizedMessage;
import com.arsdigita.xml.Element;

import com.arsdigita.search.Document;
import com.arsdigita.search.ui.QueryGenerator;
import com.arsdigita.search.ui.ResultsPane;

/**
 * A counterpart to {@link ItemSearchPopup} designed to be 
 * embedded in a form for use when javascript popup is not
 * available.
 *
 * @author Stanislav Freidin (sfreidin@arsdigita.com)
 * @version $Id: //cms/dev/src/com/arsdigita/cms/ui/ItemSearchSectionInline.java#8 $
 */
public class ItemSearchSectionInline extends ItemSearchSection {

    public static final String versionId = "$Id: //cms/dev/src/com/arsdigita/cms/ui/ItemSearchSectionInline.java#8 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    private static final org.apache.log4j.Logger s_log = 
        org.apache.log4j.Logger.getLogger(ItemSearchSectionInline.class);


    private Submit m_selectItem;
    private String m_name;

    private OIDParameter m_item;

    /**
     * Construct a new <code>ItemSearchSectionInline</code> component
     *
     * @param context the context for the retrieved items. Should be
     *   {@link ContentItem#DRAFT} or {@link ContentItem#LIVE}
     */
    public ItemSearchSectionInline(String name, String context) {
        super(name, context);
        m_name = name;
        m_item = new OIDParameter(name + "_itemOID");
    }

    public void register(Page p) {
        super.register(p);
        p.addGlobalStateParam(m_item);
    }

    protected Component createResultsPane(QueryGenerator generator) {
        return new InlineResultsPane(generator);
    }

    protected void addResultsPane(Container container) {
        super.addResultsPane(container);

        m_selectItem = new ItemSelectSubmit(
            m_name + "_itemSelect", "Select Item");
        container.add(m_selectItem);
    }

    protected void addFormListener() {
        // do nothing (ItemSearchWidget's submission listener does this.
    }

    public void processQuery(PageState state) {
        super.processQuery(state);
        m_selectItem.setVisible(state, hasQuery(state));
    }

    public boolean isItemSelected(PageState state) {
        return m_selectItem.isSelected(state);
    }

    public ContentItem getSelectedItem(PageState state) {
        OID oid = (OID)state.getValue(m_item);
        
        if (oid == null) {
            return null;
        }
        
        return (ContentItem)DomainObjectFactory.newInstance(oid);
    }
    
    private class ItemSelectSubmit extends Submit {
        public ItemSelectSubmit(String name, String label) {
            super(name, label);
        }
        public ItemSelectSubmit(String name, GlobalizedMessage label) {
            super(name, label);
        }

        public boolean isVisible(PageState ps) {
            return hasQuery(ps) && super.isVisible(ps);
        }

    }

    private class InlineResultsPane extends ResultsPane {
        public InlineResultsPane(QueryGenerator query) {
            super(query);
        }
        
        protected Element generateDocumentXML(PageState state,
                                              Document doc) {
            Element element = super.generateDocumentXML(state, doc);
            
            element.addAttribute("field", m_item.getName());
            element.addAttribute("class", "radioButton");

            return element;
        }
    }
}
