/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.ui;

import com.arsdigita.bebop.PageState;
import com.arsdigita.util.Lockable;

/**
 * Constructs a new {@link ImageBrowserModel}
 * This class will be supplied to the {@link ImageBrowser}
 * class in order to provide it with the model.
 */
public interface ImageBrowserModelBuilder extends Lockable  {

    public static final String versionId = "$Id: //cms/dev/src/com/arsdigita/cms/ui/ImageBrowserModelBuilder.java#5 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    /**
     * Construct a new ImageBrowserModel
     *
     * @param browser The {@link ImageBrowser}
     * @param state The page state
     * @return An {@link ImageBrowserModel}
     */
    ImageBrowserModel makeModel(ImageBrowser browser, PageState state);

}
