/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.ui;

import com.arsdigita.bebop.PageState;
import com.arsdigita.cms.CMS;
import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.ContentType;
import com.arsdigita.cms.ItemSelectionModel;
import com.arsdigita.cms.Template;
import com.arsdigita.cms.PageLocations;
import com.arsdigita.web.ParameterMap;
import com.arsdigita.web.URL;
import org.apache.log4j.Logger;

import java.util.List;

/**
 * <p>The context bar of the content section UI.</p>
 *
 * @author Justin Ross &lt;jross@redhat.com&gt;
 * @version $Id: //cms/dev/src/com/arsdigita/cms/ui/ContentItemContextBar.java#8 $
 */
class ContentItemContextBar extends ContentSectionContextBar {
    public static final String versionId =
        "$Id: //cms/dev/src/com/arsdigita/cms/ui/ContentItemContextBar.java#8 $" +
        "$Author: dennis $" +
        "$DateTime: 2004/04/07 16:07:11 $";

    private static final Logger s_log = Logger.getLogger
        (ContentItemContextBar.class);

    private final ItemSelectionModel m_item;

    ContentItemContextBar(final ItemSelectionModel item) {
        super();

        m_item = item;
    }

    protected final List entries(final PageState state) {
        final List entries = super.entries(state);
        final ContentItem item = (ContentItem) m_item.getSelectedObject(state);
        final ContentSection section = CMS.getContext().getContentSection();
        boolean isTemplate = 
            item.getContentType().equals(ContentType.findByAssociatedObjectType(Template.BASE_DATA_OBJECT_TYPE));

        final URL url = URL.there
            (state.getRequest(),
             section.getPath() + "/" + PageLocations.ITEM_PAGE,
             params(item));

        StringBuffer title = new StringBuffer();
        if (isTemplate) {
            title.append(localize("cms.ui.template"));
        } else {
            title.append(localize("cms.ui.content_item"));
        }
        title.append(": ")
            .append(item.getDisplayName());
        String language = item.getLanguage();
        if (language != null) {
            title.append(" (")
                .append(language)
                .append(")");
        }

        entries.add(new Entry(title.toString(), url));

        return entries;
    }

    private static ParameterMap params(final ContentItem item) {
        final ParameterMap params = new ParameterMap();

        params.setParameter(ContentItemPage.ITEM_ID, item.getID());

        return params;
    }

    private static String localize(final String key) {
        return (String) ContentSectionPage.globalize(key).localize();
    }
}
