/*
 * Copyright (C) 2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.ui;

import com.arsdigita.cms.ContentSection;
import com.arsdigita.bebop.form.DHTMLEditor;
import com.arsdigita.bebop.parameters.StringParameter;
import com.arsdigita.bebop.parameters.ParameterModel;


public class CMSDHTMLEditor extends DHTMLEditor {

    public CMSDHTMLEditor(String name) {
        super(new StringParameter(name),
              ContentSection.getConfig().getDHTMLEditorConfig());
        
        String[] plugins = ContentSection.getConfig().getDHTMLEditorPlugins();
        if (plugins != null) {
            for (int i = 0 ; i < plugins.length ; i++) {
                addPlugin(plugins[i]);
            }
        }
    }

    public CMSDHTMLEditor(ParameterModel model) {
        super(model, 
              ContentSection.getConfig().getDHTMLEditorConfig());

        String[] plugins = ContentSection.getConfig().getDHTMLEditorPlugins();
        if (plugins != null) {
            for (int i = 0 ; i < plugins.length ; i++) {
                addPlugin(plugins[i]);
            }
        }
    }

}
